/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector.models;

import com.aliyun.dashvector.models.Doc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public class Group {
    @NonNull
    private String groupId;
    private List<Doc> docs;

    Group(@NonNull String groupId, List<Doc> docs) {
        if (groupId == null) {
            throw new NullPointerException("groupId is marked non-null but is null");
        }
        this.groupId = groupId;
        this.docs = docs;
    }

    public static GroupBuilder builder() {
        return new GroupBuilder();
    }

    @NonNull
    public String getGroupId() {
        return this.groupId;
    }

    public List<Doc> getDocs() {
        return this.docs;
    }

    public static class GroupBuilder {
        private String groupId;
        private ArrayList<Doc> docs;

        GroupBuilder() {
        }

        public GroupBuilder groupId(@NonNull String groupId) {
            if (groupId == null) {
                throw new NullPointerException("groupId is marked non-null but is null");
            }
            this.groupId = groupId;
            return this;
        }

        public GroupBuilder doc(Doc doc) {
            if (this.docs == null) {
                this.docs = new ArrayList();
            }
            this.docs.add(doc);
            return this;
        }

        public GroupBuilder docs(Collection<? extends Doc> docs) {
            if (docs == null) {
                throw new NullPointerException("docs cannot be null");
            }
            if (this.docs == null) {
                this.docs = new ArrayList();
            }
            this.docs.addAll(docs);
            return this;
        }

        public GroupBuilder clearDocs() {
            if (this.docs != null) {
                this.docs.clear();
            }
            return this;
        }

        public Group build() {
            List<Doc> docs;
            switch (this.docs == null ? 0 : this.docs.size()) {
                case 0: {
                    docs = Collections.emptyList();
                    break;
                }
                case 1: {
                    docs = Collections.singletonList(this.docs.get(0));
                    break;
                }
                default: {
                    docs = Collections.unmodifiableList(new ArrayList<Doc>(this.docs));
                }
            }
            return new Group(this.groupId, docs);
        }

        public String toString() {
            return "Group.GroupBuilder(groupId=" + this.groupId + ", docs=" + this.docs + ")";
        }
    }
}

