/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector.models;

import java.util.Map;
import lombok.NonNull;

public class SparseVector {
    @NonNull
    private Map<Long, Float> value;

    SparseVector(@NonNull Map<Long, Float> value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }

    public static SparseVectorBuilder builder() {
        return new SparseVectorBuilder();
    }

    @NonNull
    public Map<Long, Float> getValue() {
        return this.value;
    }

    public static class SparseVectorBuilder {
        private Map<Long, Float> value;

        SparseVectorBuilder() {
        }

        public SparseVectorBuilder value(@NonNull Map<Long, Float> value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
            return this;
        }

        public SparseVector build() {
            return new SparseVector(this.value);
        }

        public String toString() {
            return "SparseVector.SparseVectorBuilder(value=" + this.value + ")";
        }
    }
}

