/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector.models;

import com.aliyun.dashvector.models.Ranker;
import com.aliyun.dashvector.proto.Ranker;
import java.util.Map;
import java.util.Objects;

public class WeightedRanker
implements Ranker {
    private Map<String, Float> weights;

    private String weightsToJson() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Map.Entry<String, Float> entry : this.weights.entrySet()) {
            sb.append("\"").append(entry.getKey()).append("\":").append(entry.getValue()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public com.aliyun.dashvector.proto.Ranker toProto() {
        Ranker.Builder builder = com.aliyun.dashvector.proto.Ranker.newBuilder().setRankerName("weighted");
        if (Objects.nonNull(this.weights)) {
            builder.putRankerParams("weights", this.weightsToJson());
        }
        return builder.build();
    }

    WeightedRanker(Map<String, Float> weights) {
        this.weights = weights;
    }

    public static WeightedRankerBuilder builder() {
        return new WeightedRankerBuilder();
    }

    public Map<String, Float> getWeights() {
        return this.weights;
    }

    public static class WeightedRankerBuilder {
        private Map<String, Float> weights;

        WeightedRankerBuilder() {
        }

        public WeightedRankerBuilder weights(Map<String, Float> weights) {
            this.weights = weights;
            return this;
        }

        public WeightedRanker build() {
            return new WeightedRanker(this.weights);
        }

        public String toString() {
            return "WeightedRanker.WeightedRankerBuilder(weights=" + this.weights + ")";
        }
    }
}

