/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector.models.requests;

import com.aliyun.dashvector.common.DashVectorException;
import com.aliyun.dashvector.models.VectorParam;
import com.aliyun.dashvector.proto.CollectionInfo;
import com.aliyun.dashvector.proto.CreateCollectionRequest;
import com.aliyun.dashvector.proto.FieldType;
import com.aliyun.dashvector.utils.Convertor;
import com.aliyun.dashvector.utils.Validator;
import com.aliyun.dashvector.validator.ValidatorFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.collections.MapUtils;

public class CreateCollectionRequest {
    @NonNull
    private String name;
    private int dimension;
    @NonNull
    private CollectionInfo.DataType dataType;
    @NonNull
    private CollectionInfo.Metric metric;
    private Map<String, FieldType> filedsSchema;
    private Map<String, String> extraParams;
    private Integer timeout;
    private Map<String, VectorParam> vectors;
    private VectorParam vectorParam;
    private Map<String, VectorParam> sparseVectors;

    public com.aliyun.dashvector.proto.CreateCollectionRequest toProto() throws DashVectorException {
        ValidatorFactory.create(this).validate();
        CreateCollectionRequest.Builder builder = com.aliyun.dashvector.proto.CreateCollectionRequest.newBuilder().setName(this.name).setDimension(this.dimension).setDtype(this.dataType).setMetric(this.metric);
        if (MapUtils.isNotEmpty(this.vectors)) {
            this.vectors.forEach((k, v) -> builder.putVectorsSchema((String)k, Convertor.toVectorParam(v)));
        } else if (Objects.nonNull(this.vectorParam)) {
            builder.putVectorsSchema("", Convertor.toVectorParam(this.vectorParam));
        }
        if (MapUtils.isNotEmpty(this.sparseVectors)) {
            this.sparseVectors.forEach((k, v) -> builder.putSparseVectorsSchema((String)k, Convertor.toVectorParam(v)));
        }
        if (MapUtils.isNotEmpty(this.filedsSchema)) {
            builder.putAllFieldsSchema(Convertor.toFieldsSchema(this.filedsSchema));
        }
        if (MapUtils.isNotEmpty(this.extraParams)) {
            builder.putAllExtraParams(this.extraParams);
        }
        com.aliyun.dashvector.proto.CreateCollectionRequest request = builder.build();
        Validator.verifyRequestSize(request);
        return request;
    }

    private static CollectionInfo.DataType $default$dataType() {
        return CollectionInfo.DataType.FLOAT;
    }

    private static CollectionInfo.Metric $default$metric() {
        return CollectionInfo.Metric.cosine;
    }

    private static Map<String, String> $default$extraParams() {
        return new HashMap<String, String>();
    }

    CreateCollectionRequest(@NonNull String name, int dimension, @NonNull CollectionInfo.DataType dataType, @NonNull CollectionInfo.Metric metric, Map<String, FieldType> filedsSchema, Map<String, String> extraParams, Integer timeout, Map<String, VectorParam> vectors, VectorParam vectorParam, Map<String, VectorParam> sparseVectors) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        if (metric == null) {
            throw new NullPointerException("metric is marked non-null but is null");
        }
        this.name = name;
        this.dimension = dimension;
        this.dataType = dataType;
        this.metric = metric;
        this.filedsSchema = filedsSchema;
        this.extraParams = extraParams;
        this.timeout = timeout;
        this.vectors = vectors;
        this.vectorParam = vectorParam;
        this.sparseVectors = sparseVectors;
    }

    public static CreateCollectionRequestBuilder builder() {
        return new CreateCollectionRequestBuilder();
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public int getDimension() {
        return this.dimension;
    }

    @NonNull
    public CollectionInfo.DataType getDataType() {
        return this.dataType;
    }

    @NonNull
    public CollectionInfo.Metric getMetric() {
        return this.metric;
    }

    public Map<String, FieldType> getFiledsSchema() {
        return this.filedsSchema;
    }

    public Map<String, String> getExtraParams() {
        return this.extraParams;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Map<String, VectorParam> getVectors() {
        return this.vectors;
    }

    public VectorParam getVectorParam() {
        return this.vectorParam;
    }

    public Map<String, VectorParam> getSparseVectors() {
        return this.sparseVectors;
    }

    public static class CreateCollectionRequestBuilder {
        private String name;
        private int dimension;
        private boolean dataType$set;
        private CollectionInfo.DataType dataType$value;
        private boolean metric$set;
        private CollectionInfo.Metric metric$value;
        private ArrayList<String> filedsSchema$key;
        private ArrayList<FieldType> filedsSchema$value;
        private boolean extraParams$set;
        private Map<String, String> extraParams$value;
        private Integer timeout;
        private ArrayList<String> vectors$key;
        private ArrayList<VectorParam> vectors$value;
        private VectorParam vectorParam;
        private ArrayList<String> sparseVectors$key;
        private ArrayList<VectorParam> sparseVectors$value;

        CreateCollectionRequestBuilder() {
        }

        public CreateCollectionRequestBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public CreateCollectionRequestBuilder dimension(int dimension) {
            this.dimension = dimension;
            return this;
        }

        public CreateCollectionRequestBuilder dataType(@NonNull CollectionInfo.DataType dataType) {
            if (dataType == null) {
                throw new NullPointerException("dataType is marked non-null but is null");
            }
            this.dataType$value = dataType;
            this.dataType$set = true;
            return this;
        }

        public CreateCollectionRequestBuilder metric(@NonNull CollectionInfo.Metric metric) {
            if (metric == null) {
                throw new NullPointerException("metric is marked non-null but is null");
            }
            this.metric$value = metric;
            this.metric$set = true;
            return this;
        }

        public CreateCollectionRequestBuilder filedSchema(String filedSchemaKey, FieldType filedSchemaValue) {
            if (this.filedsSchema$key == null) {
                this.filedsSchema$key = new ArrayList();
                this.filedsSchema$value = new ArrayList();
            }
            this.filedsSchema$key.add(filedSchemaKey);
            this.filedsSchema$value.add(filedSchemaValue);
            return this;
        }

        public CreateCollectionRequestBuilder filedsSchema(Map<? extends String, ? extends FieldType> filedsSchema) {
            if (filedsSchema == null) {
                throw new NullPointerException("filedsSchema cannot be null");
            }
            if (this.filedsSchema$key == null) {
                this.filedsSchema$key = new ArrayList();
                this.filedsSchema$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends FieldType> $lombokEntry : filedsSchema.entrySet()) {
                this.filedsSchema$key.add($lombokEntry.getKey());
                this.filedsSchema$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public CreateCollectionRequestBuilder clearFiledsSchema() {
            if (this.filedsSchema$key != null) {
                this.filedsSchema$key.clear();
                this.filedsSchema$value.clear();
            }
            return this;
        }

        public CreateCollectionRequestBuilder extraParams(Map<String, String> extraParams) {
            this.extraParams$value = extraParams;
            this.extraParams$set = true;
            return this;
        }

        public CreateCollectionRequestBuilder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public CreateCollectionRequestBuilder vectors(String vectorsKey, VectorParam vectorsValue) {
            if (this.vectors$key == null) {
                this.vectors$key = new ArrayList();
                this.vectors$value = new ArrayList();
            }
            this.vectors$key.add(vectorsKey);
            this.vectors$value.add(vectorsValue);
            return this;
        }

        public CreateCollectionRequestBuilder vectors(Map<? extends String, ? extends VectorParam> vectors) {
            if (vectors == null) {
                throw new NullPointerException("vectors cannot be null");
            }
            if (this.vectors$key == null) {
                this.vectors$key = new ArrayList();
                this.vectors$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends VectorParam> $lombokEntry : vectors.entrySet()) {
                this.vectors$key.add($lombokEntry.getKey());
                this.vectors$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public CreateCollectionRequestBuilder clearVectors() {
            if (this.vectors$key != null) {
                this.vectors$key.clear();
                this.vectors$value.clear();
            }
            return this;
        }

        public CreateCollectionRequestBuilder vectorParam(VectorParam vectorParam) {
            this.vectorParam = vectorParam;
            return this;
        }

        public CreateCollectionRequestBuilder sparseVectors(String sparseVectorsKey, VectorParam sparseVectorsValue) {
            if (this.sparseVectors$key == null) {
                this.sparseVectors$key = new ArrayList();
                this.sparseVectors$value = new ArrayList();
            }
            this.sparseVectors$key.add(sparseVectorsKey);
            this.sparseVectors$value.add(sparseVectorsValue);
            return this;
        }

        public CreateCollectionRequestBuilder sparseVectors(Map<? extends String, ? extends VectorParam> sparseVectors) {
            if (sparseVectors == null) {
                throw new NullPointerException("sparseVectors cannot be null");
            }
            if (this.sparseVectors$key == null) {
                this.sparseVectors$key = new ArrayList();
                this.sparseVectors$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends VectorParam> $lombokEntry : sparseVectors.entrySet()) {
                this.sparseVectors$key.add($lombokEntry.getKey());
                this.sparseVectors$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public CreateCollectionRequestBuilder clearSparseVectors() {
            if (this.sparseVectors$key != null) {
                this.sparseVectors$key.clear();
                this.sparseVectors$value.clear();
            }
            return this;
        }

        public CreateCollectionRequest build() {
            Map<Object, Object> sparseVectors;
            Map<Object, Object> vectors;
            Map<Object, Object> filedsSchema;
            switch (this.filedsSchema$key == null ? 0 : this.filedsSchema$key.size()) {
                case 0: {
                    filedsSchema = Collections.emptyMap();
                    break;
                }
                case 1: {
                    filedsSchema = Collections.singletonMap(this.filedsSchema$key.get(0), this.filedsSchema$value.get(0));
                    break;
                }
                default: {
                    filedsSchema = new LinkedHashMap(this.filedsSchema$key.size() < 0x40000000 ? 1 + this.filedsSchema$key.size() + (this.filedsSchema$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.filedsSchema$key.size(); ++$i) {
                        filedsSchema.put(this.filedsSchema$key.get($i), this.filedsSchema$value.get($i));
                    }
                    filedsSchema = Collections.unmodifiableMap(filedsSchema);
                }
            }
            switch (this.vectors$key == null ? 0 : this.vectors$key.size()) {
                case 0: {
                    vectors = Collections.emptyMap();
                    break;
                }
                case 1: {
                    vectors = Collections.singletonMap(this.vectors$key.get(0), this.vectors$value.get(0));
                    break;
                }
                default: {
                    vectors = new LinkedHashMap(this.vectors$key.size() < 0x40000000 ? 1 + this.vectors$key.size() + (this.vectors$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.vectors$key.size(); ++$i) {
                        vectors.put(this.vectors$key.get($i), this.vectors$value.get($i));
                    }
                    vectors = Collections.unmodifiableMap(vectors);
                }
            }
            switch (this.sparseVectors$key == null ? 0 : this.sparseVectors$key.size()) {
                case 0: {
                    sparseVectors = Collections.emptyMap();
                    break;
                }
                case 1: {
                    sparseVectors = Collections.singletonMap(this.sparseVectors$key.get(0), this.sparseVectors$value.get(0));
                    break;
                }
                default: {
                    sparseVectors = new LinkedHashMap(this.sparseVectors$key.size() < 0x40000000 ? 1 + this.sparseVectors$key.size() + (this.sparseVectors$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.sparseVectors$key.size(); ++$i) {
                        sparseVectors.put(this.sparseVectors$key.get($i), this.sparseVectors$value.get($i));
                    }
                    sparseVectors = Collections.unmodifiableMap(sparseVectors);
                }
            }
            CollectionInfo.DataType dataType$value = this.dataType$value;
            if (!this.dataType$set) {
                dataType$value = CreateCollectionRequest.$default$dataType();
            }
            CollectionInfo.Metric metric$value = this.metric$value;
            if (!this.metric$set) {
                metric$value = CreateCollectionRequest.$default$metric();
            }
            Map extraParams$value = this.extraParams$value;
            if (!this.extraParams$set) {
                extraParams$value = CreateCollectionRequest.$default$extraParams();
            }
            return new CreateCollectionRequest(this.name, this.dimension, dataType$value, metric$value, filedsSchema, extraParams$value, this.timeout, vectors, this.vectorParam, sparseVectors);
        }

        public String toString() {
            return "CreateCollectionRequest.CreateCollectionRequestBuilder(name=" + this.name + ", dimension=" + this.dimension + ", dataType$value=" + this.dataType$value + ", metric$value=" + this.metric$value + ", filedsSchema$key=" + this.filedsSchema$key + ", filedsSchema$value=" + this.filedsSchema$value + ", extraParams$value=" + this.extraParams$value + ", timeout=" + this.timeout + ", vectors$key=" + this.vectors$key + ", vectors$value=" + this.vectors$value + ", vectorParam=" + this.vectorParam + ", sparseVectors$key=" + this.sparseVectors$key + ", sparseVectors$value=" + this.sparseVectors$value + ")";
        }
    }
}

