/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector.validator;

import com.aliyun.dashvector.common.DashVectorException;
import com.aliyun.dashvector.common.ErrorCode;
import com.aliyun.dashvector.models.CollectionMeta;
import com.aliyun.dashvector.models.requests.CreateCollectionRequest;
import com.aliyun.dashvector.validator.CreateCollectionValidator;
import com.aliyun.dashvector.validator.MultiVectorValidator;
import com.aliyun.dashvector.validator.ReserveVectorValidator;
import com.aliyun.dashvector.validator.VectorValidator;
import org.apache.commons.collections.MapUtils;

public class ValidatorFactory {
    public static VectorValidator create(CollectionMeta meta) {
        if (meta == null) {
            throw new DashVectorException(ErrorCode.INVALID_COLLECTION_META, "Collection meta is null");
        }
        if (MapUtils.isNotEmpty(meta.getVectors()) || MapUtils.isNotEmpty(meta.getSparseVectors())) {
            if (meta.getVectors().containsKey("proxima_vector")) {
                return new ReserveVectorValidator(meta);
            }
            if (meta.getSparseVectors().containsKey("proxima_sparse_vector")) {
                return new ReserveVectorValidator(meta);
            }
            return new MultiVectorValidator(meta);
        }
        if (meta.getDimension() > 0) {
            return new ReserveVectorValidator(meta);
        }
        throw new DashVectorException(ErrorCode.INVALID_COLLECTION_META, String.format("Collection meta is invalid. meta:[%s]", meta));
    }

    public static CreateCollectionValidator create(CreateCollectionRequest request) {
        boolean hasVectorSchema;
        boolean hasVector = request.getDimension() > 0 || request.getVectorParam() != null;
        boolean bl = hasVectorSchema = MapUtils.isNotEmpty(request.getVectors()) || MapUtils.isNotEmpty(request.getSparseVectors());
        if (hasVectorSchema && hasVector) {
            throw new DashVectorException(ErrorCode.INVALID_ARGUMENT, "DashVectorSDK does not support support passing in dimension(vector_param) and vectors simultaneously");
        }
        if (hasVectorSchema) {
            return new CreateCollectionValidator.MultiVectorCreateCollectionValidator(request);
        }
        return new CreateCollectionValidator.ReserveCreateCollectionValidator(request);
    }
}

