/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector.validator;

import com.aliyun.dashvector.common.DashVectorException;
import com.aliyun.dashvector.common.ErrorCode;
import com.aliyun.dashvector.models.CollectionMeta;
import com.aliyun.dashvector.models.Doc;
import com.aliyun.dashvector.models.requests.QueryDocGroupByRequest;
import com.aliyun.dashvector.models.requests.QueryDocRequest;
import com.aliyun.dashvector.models.requests.WriteDocRequest;
import com.aliyun.dashvector.proto.DocOpResult;
import com.aliyun.dashvector.utils.Validator;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class VectorValidator {
    protected final CollectionMeta meta;

    protected VectorValidator(CollectionMeta meta) {
        this.meta = meta;
    }

    protected abstract void validateVectorFromDoc(Doc var1, DocOpResult.DocOp var2);

    protected abstract void validateVectorFromQuery(QueryDocRequest var1);

    protected abstract void validateVectorFromQueryGroupBy(QueryDocGroupByRequest var1);

    public void validateWriteDocRequest(WriteDocRequest<?> request, DocOpResult.DocOp docOp) {
        Validator.verifyBatchSize(request.getDocs());
        Validator.verifyPartitionName(request.getPartition());
        request.getDocs().forEach(doc -> {
            Validator.verifyDocId(doc.getId());
            this.validateVectorFromDoc((Doc)doc, docOp);
            Validator.verifyFieldsValue(doc.getFields(), this.meta.getFieldsSchema());
        });
    }

    public void validateQueryDocRequest(QueryDocRequest request) {
        boolean queryByVector;
        Validator.verifyPartitionName(request.getPartition());
        boolean queryById = StringUtils.isNotEmpty((CharSequence)request.getId());
        boolean bl = queryByVector = request.getVector() != null || request.getVectorQuery() != null || MapUtils.isNotEmpty(request.getVectors()) || MapUtils.isNotEmpty(request.getSparseVector()) || MapUtils.isNotEmpty(request.getSparseVectors());
        if (queryByVector && queryById) {
            throw new DashVectorException(ErrorCode.EXIST_VECTOR_ID);
        }
        Validator.verifyOutputFields(request.getOutputFields());
        Validator.verifyFilter(request.getFilter());
        if (queryByVector) {
            this.validateVectorFromQuery(request);
        } else {
            Validator.verifyDocId(request.getId());
            Validator.verifyTopK(request.getTopk(), request.isIncludeVector());
        }
    }

    public void validateQueryDocGroupByRequest(QueryDocGroupByRequest request) {
        boolean queryByVector;
        Validator.verifyPartitionName(request.getPartition());
        boolean queryById = StringUtils.isNotEmpty((CharSequence)request.getId());
        boolean bl = queryByVector = request.getVector() != null || MapUtils.isNotEmpty(request.getSparseVector());
        if (queryByVector && queryById) {
            throw new DashVectorException(ErrorCode.EXIST_VECTOR_ID);
        }
        if (StringUtils.isEmpty((CharSequence)request.getGroupByField())) {
            throw new DashVectorException(ErrorCode.INVALID_GROUP_BY, "GroupByField is empty");
        }
        Validator.verifyOutputFields(request.getOutputFields());
        Validator.verifyGroupTopK(request.getGroupTopk(), request.isIncludeVector());
        Validator.verifyGroupCount(request.getGroupCount(), request.isIncludeVector());
        Validator.verifyFilter(request.getFilter());
        if (queryByVector) {
            this.validateVectorFromQueryGroupBy(request);
        } else {
            Validator.verifyDocId(request.getId());
        }
    }
}

