/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.rocketmq;

import com.alibaba.rocketmq.client.exception.MQClientException;
import com.alibaba.rocketmq.client.hook.SendMessageHook;
import com.alibaba.rocketmq.client.producer.LocalTransactionExecuter;
import com.alibaba.rocketmq.client.producer.LocalTransactionState;
import com.alibaba.rocketmq.client.producer.TransactionCheckListener;
import com.alibaba.rocketmq.client.producer.TransactionMQProducer;
import com.alibaba.rocketmq.client.producer.TransactionSendResult;
import com.alibaba.rocketmq.common.message.MessageAccessor;
import com.alibaba.rocketmq.remoting.RPCHook;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.impl.rocketmq.ClientRPCHook;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSClientAbstract;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSUtil;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;
import com.aliyun.openservices.ons.api.transaction.TransactionStatus;
import com.taobao.metaq.client.eagleeye.SendMessageHookImpl;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;

public class TransactionProducerImpl
extends ONSClientAbstract
implements TransactionProducer {
    TransactionMQProducer transactionMQProducer = null;
    private Properties properties;
    private final AtomicBoolean started = new AtomicBoolean(false);

    public TransactionProducerImpl(Properties properties, TransactionCheckListener transactionCheckListener) {
        super(properties);
        this.properties = properties;
        this.transactionMQProducer = new TransactionMQProducer((String)properties.get("ProducerId"), (RPCHook)new ClientRPCHook(this.sessionCredentials));
        this.transactionMQProducer.setTransactionCheckListener(transactionCheckListener);
        try {
            this.transactionMQProducer.getDefaultMQProducerImpl().registerSendMessageHook((SendMessageHook)new SendMessageHookImpl());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void start() {
        if (this.started.compareAndSet(false, true)) {
            if (this.transactionMQProducer.getTransactionCheckListener() == null) {
                throw new IllegalArgumentException("TransactionCheckListener is null");
            }
            this.transactionMQProducer.setNamesrvAddr(this.nameServerAddr);
            try {
                this.transactionMQProducer.start();
            }
            catch (MQClientException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void shutdown() {
        if (this.started.compareAndSet(true, false)) {
            this.transactionMQProducer.shutdown();
        }
    }

    public SendResult send(final Message message, final com.aliyun.openservices.ons.api.transaction.LocalTransactionExecuter executer, Object arg) {
        com.alibaba.rocketmq.common.message.Message msgRMQ = ONSUtil.msgConvert(message);
        MessageAccessor.putProperty((com.alibaba.rocketmq.common.message.Message)msgRMQ, (String)"ProducerId", (String)((String)this.properties.get("ProducerId")));
        TransactionSendResult sendResultRMQ = null;
        try {
            sendResultRMQ = this.transactionMQProducer.sendMessageInTransaction(msgRMQ, new LocalTransactionExecuter(){

                public LocalTransactionState executeLocalTransactionBranch(com.alibaba.rocketmq.common.message.Message msg, Object arg) {
                    String msgId = msg.getProperty("__transactionId__");
                    message.setMsgID(msgId);
                    TransactionStatus transactionStatus = executer.execute(message, arg);
                    if (TransactionStatus.CommitTransaction == transactionStatus) {
                        return LocalTransactionState.COMMIT_MESSAGE;
                    }
                    if (TransactionStatus.RollbackTransaction == transactionStatus) {
                        return LocalTransactionState.ROLLBACK_MESSAGE;
                    }
                    return LocalTransactionState.UNKNOW;
                }
            }, arg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SendResult sendResult = new SendResult();
        sendResult.setMessageId(sendResultRMQ.getMsgId());
        if (sendResultRMQ.getTransactionId() != null) {
            sendResult.setMessageId(sendResultRMQ.getTransactionId());
        }
        return sendResult;
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isClosed() {
        return !this.isStarted();
    }
}

