/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.auth;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.auth.CredentialsProvider;
import com.alicloud.openservices.tablestore.core.auth.InstanceProfileCredentials;
import com.alicloud.openservices.tablestore.core.auth.InstanceProfileCredentialsFetcher;
import com.alicloud.openservices.tablestore.core.auth.ServiceCredentials;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceProfileCredentialsProvider
implements CredentialsProvider {
    private static Logger logger = LoggerFactory.getLogger(InstanceProfileCredentialsProvider.class);
    private final String roleName;
    private volatile InstanceProfileCredentials credentials;
    private InstanceProfileCredentialsFetcher fetcher;
    private final AtomicBoolean isFetching = new AtomicBoolean(false);
    private int maxRetryTimes = 3;

    public InstanceProfileCredentialsProvider(String roleName) {
        if (null == roleName) {
            throw new NullPointerException("You must specify a valid role name.");
        }
        this.roleName = roleName;
        this.fetcher = new InstanceProfileCredentialsFetcher();
        this.fetcher.setRoleName(this.roleName);
    }

    public InstanceProfileCredentialsProvider withCredentialsFetcher(InstanceProfileCredentialsFetcher fetcher) {
        this.fetcher = fetcher;
        return this;
    }

    @Override
    public void setCredentials(ServiceCredentials creds) {
    }

    public boolean isCredentialsInvalid() {
        return this.credentials == null || this.credentials.isExpired();
    }

    public boolean shouldRefreshCredentials() {
        return !this.isFetching.get() && this.credentials.willSoonExpire() && this.credentials.shouldRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstanceProfileCredentials getCredentials() {
        if (this.isCredentialsInvalid() || this.shouldRefreshCredentials()) {
            InstanceProfileCredentialsProvider instanceProfileCredentialsProvider = this;
            synchronized (instanceProfileCredentialsProvider) {
                if (this.isCredentialsInvalid()) {
                    try {
                        this.credentials = (InstanceProfileCredentials)this.fetcher.fetch(this.maxRetryTimes);
                    }
                    catch (ClientException e) {
                        logger.error("EcsInstanceCredentialsFetcher.fetch Exception:", (Throwable)e);
                        return null;
                    }
                }
                if (this.shouldRefreshCredentials()) {
                    try {
                        this.isFetching.set(true);
                        this.credentials = (InstanceProfileCredentials)this.fetcher.fetch(this.maxRetryTimes);
                    }
                    catch (ClientException e) {
                        this.credentials.setLastFailedRefreshTime();
                        logger.error("EcsInstanceCredentialsFetcher.fetch Exception:", (Throwable)e);
                    }
                    finally {
                        this.isFetching.set(false);
                    }
                }
            }
        }
        return this.credentials;
    }
}

