/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.ecosystem;

import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.ecosystem.ICatalog;
import com.alicloud.openservices.tablestore.model.DescribeTableRequest;
import com.alicloud.openservices.tablestore.model.DescribeTableResponse;
import com.alicloud.openservices.tablestore.model.IndexMeta;
import com.alicloud.openservices.tablestore.model.TableMeta;
import com.alicloud.openservices.tablestore.model.search.DescribeSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.DescribeSearchIndexResponse;
import com.alicloud.openservices.tablestore.model.search.IndexSchema;
import com.alicloud.openservices.tablestore.model.search.ListSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.SearchIndexInfo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableCatalog
implements ICatalog {
    private static final Logger LOG = LoggerFactory.getLogger(TableCatalog.class);
    private String name;
    private TableMeta tableMeta;
    private List<TableMeta> indexMetaList = new ArrayList<TableMeta>();
    private List<IndexSchema> searchSchema = new ArrayList<IndexSchema>();
    private List<String> searchNames = new ArrayList<String>();

    public TableCatalog(String tableName) {
        this.name = tableName;
    }

    public String getName() {
        return this.name;
    }

    public TableMeta getTableMeta() {
        return this.tableMeta;
    }

    public List<TableMeta> getIndexMetaList() {
        return this.indexMetaList;
    }

    public List<IndexSchema> getSearchSchema() {
        return this.searchSchema;
    }

    public List<String> getSearchNames() {
        return this.searchNames;
    }

    public void buildCatalog(SyncClient client) {
        this.buildTableAndIndexMeta(client);
        try {
            this.buildSearchIndexMeta(client);
        }
        catch (TableStoreException ex) {
            LOG.error("hit Tablestore exception during fetch search meta : {}", (Object)ex.toString());
        }
    }

    private void buildTableAndIndexMeta(SyncClient client) {
        DescribeTableRequest describeTableRequest = new DescribeTableRequest(this.name);
        DescribeTableResponse result = client.describeTable(describeTableRequest);
        this.tableMeta = result.getTableMeta();
        for (IndexMeta meta : result.getIndexMeta()) {
            DescribeTableRequest describeTableRequest2 = new DescribeTableRequest(meta.getIndexName());
            DescribeTableResponse result2 = client.describeTable(describeTableRequest2);
            this.indexMetaList.add(result2.getTableMeta());
        }
    }

    private void buildSearchIndexMeta(SyncClient client) {
        ListSearchIndexRequest request = new ListSearchIndexRequest();
        request.setTableName(this.name);
        List<SearchIndexInfo> indexInfos = client.listSearchIndex(request).getIndexInfos();
        for (SearchIndexInfo indexInfo : indexInfos) {
            DescribeSearchIndexRequest request2 = new DescribeSearchIndexRequest();
            request2.setTableName(indexInfo.getTableName());
            request2.setIndexName(indexInfo.getIndexName());
            DescribeSearchIndexResponse response = client.describeSearchIndex(request2);
            this.searchSchema.add(response.getSchema());
            this.searchNames.add(indexInfo.getIndexName());
        }
    }

    public static enum TableType {
        Normal,
        SearchIndex;

    }
}

