/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Jsonizable;
import com.alicloud.openservices.tablestore.core.utils.OptionalValue;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;

public class CapacityDataSize
implements Jsonizable {
    private OptionalValue<Long> readCapacityDataSize = new OptionalValue("ReadCapacityDataSize");
    private OptionalValue<Long> writeCapacityDataSize = new OptionalValue("WriteCapacityDataSize");

    public CapacityDataSize() {
    }

    public CapacityDataSize(long readCapacityDataSize, long writeCapacityDataSize) {
        this.setReadCapacityDataSize(readCapacityDataSize);
        this.setWriteCapacityDataSize(writeCapacityDataSize);
    }

    public long getReadCapacityDataSize() {
        if (!this.readCapacityDataSize.isValueSet()) {
            throw new IllegalStateException("The value of read capacity unit is not set.");
        }
        return this.readCapacityDataSize.getValue();
    }

    public void setReadCapacityDataSize(long readCapacityDataSize) {
        Preconditions.checkArgument(readCapacityDataSize >= 0L, "The value of read capacity DataSize can't be negative.");
        this.readCapacityDataSize.setValue(readCapacityDataSize);
    }

    public boolean hasSetReadCapacityDataSize() {
        return this.readCapacityDataSize.isValueSet();
    }

    public void clearReadCapacityDataSize() {
        this.readCapacityDataSize.clear();
    }

    public long getWriteCapacityDataSize() {
        if (!this.writeCapacityDataSize.isValueSet()) {
            throw new IllegalStateException("The value of write capacity unit is not set.");
        }
        return this.writeCapacityDataSize.getValue();
    }

    public void setWriteCapacityDataSize(long writeCapacityDataSize) {
        Preconditions.checkArgument(writeCapacityDataSize >= 0L, "The value of write capacity unit can't be negative.");
        this.writeCapacityDataSize.setValue(writeCapacityDataSize);
    }

    public boolean hasSetWriteCapacityDataSize() {
        return this.writeCapacityDataSize.isValueSet();
    }

    public void clearWriteCapacityDataSize() {
        this.writeCapacityDataSize.clear();
    }

    public int hashCode() {
        return this.readCapacityDataSize.hashCode() ^ this.writeCapacityDataSize.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CapacityDataSize)) {
            return false;
        }
        CapacityDataSize c1 = (CapacityDataSize)o;
        return this.readCapacityDataSize.equals(c1.readCapacityDataSize) && this.writeCapacityDataSize.equals(c1.writeCapacityDataSize);
    }

    public String toString() {
        return "" + this.readCapacityDataSize + ", " + this.writeCapacityDataSize;
    }

    @Override
    public String jsonize() {
        StringBuilder sb = new StringBuilder();
        this.jsonize(sb, "\n  ");
        return sb.toString();
    }

    @Override
    public void jsonize(StringBuilder sb, String newline) {
        boolean firstItem = true;
        sb.append('{');
        if (this.readCapacityDataSize.isValueSet()) {
            if (firstItem) {
                firstItem = false;
            } else {
                sb.append(", ");
            }
            sb.append("\"Read_Size\": ");
            sb.append(this.readCapacityDataSize.getValue());
        }
        if (this.writeCapacityDataSize.isValueSet()) {
            if (firstItem) {
                firstItem = false;
            } else {
                sb.append(", ");
            }
            sb.append("\"Write_Size\": ");
            sb.append(this.writeCapacityDataSize.getValue());
        }
        sb.append('}');
    }
}

