/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.SyncClientInterface;
import com.alicloud.openservices.tablestore.model.BulkExportRequest;
import com.alicloud.openservices.tablestore.model.BulkExportResponse;
import com.alicloud.openservices.tablestore.model.DataBlockType;
import com.alicloud.openservices.tablestore.model.PlainBufferBlockParser;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.tunnel.BulkExportQueryCriteria;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PlainBufferBlockRowIterator
implements Iterator<Row> {
    private SyncClientInterface client;
    private BulkExportQueryCriteria parameter;
    private BulkExportResponse result;
    private Iterator<Row> rowsIter;

    public PlainBufferBlockRowIterator(SyncClientInterface client, BulkExportQueryCriteria parameter) {
        this.client = client;
        this.parameter = parameter;
        this.fetchData(this.buildRequest());
    }

    private BulkExportRequest buildRequest() {
        BulkExportQueryCriteria criteria = new BulkExportQueryCriteria(this.parameter.getTableName());
        if (this.parameter.hasSetFilter()) {
            criteria.setFilter(this.parameter.getFilter());
        }
        if (this.result == null) {
            criteria.setInclusiveStartPrimaryKey(this.parameter.getInclusiveStartPrimaryKey());
        } else {
            criteria.setInclusiveStartPrimaryKey(this.result.getNextStartPrimaryKey());
        }
        criteria.setExclusiveEndPrimaryKey(this.parameter.getExclusiveEndPrimaryKey());
        criteria.setDataBlockType(DataBlockType.DBT_PLAIN_BUFFER);
        criteria.addColumnsToGet(this.parameter.getColumnsToGet());
        if (this.parameter.hasSetFilter()) {
            criteria.setFilter(this.parameter.getFilter());
        }
        return new BulkExportRequest(criteria);
    }

    private void fetchData(BulkExportRequest request) {
        this.result = this.client.bulkExport(request);
        this.rowsIter = new PlainBufferBlockParser(this.result.getRows()).getRows().iterator();
    }

    private boolean isBufferHasMoreData() {
        return this.rowsIter.hasNext();
    }

    private Row getNextFromBuffer() {
        return this.rowsIter.next();
    }

    @Override
    public boolean hasNext() {
        if (this.isBufferHasMoreData()) {
            return true;
        }
        PrimaryKey nextToken = this.result.getNextStartPrimaryKey();
        while (nextToken != null && !nextToken.isEmpty()) {
            this.fetchData(this.buildRequest());
            if (this.isBufferHasMoreData()) {
                return true;
            }
            nextToken = this.result.getNextStartPrimaryKey();
        }
        return false;
    }

    @Override
    public Row next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.getNextFromBuffer();
    }

    @Override
    public void remove() {
        throw new ClientException("RowIterator do not support remove().");
    }
}

