/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.OptionalValue;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.RowChange;
import java.util.ArrayList;
import java.util.List;

public class RowPutChange
extends RowChange {
    private List<Column> columnsToPut = new ArrayList<Column>();
    private OptionalValue<Long> timestamp = new OptionalValue("Timestamp");

    public RowPutChange(String tableName) {
        super(tableName);
    }

    public RowPutChange(String tableName, PrimaryKey primaryKey) {
        super(tableName, primaryKey);
    }

    public RowPutChange(String tableName, PrimaryKey primaryKey, long ts) {
        super(tableName, primaryKey);
        this.timestamp.setValue(ts);
    }

    public RowPutChange(RowPutChange toCopy) {
        super(toCopy.getTableName(), toCopy.getPrimaryKey());
        if (toCopy.timestamp.isValueSet()) {
            this.timestamp.setValue(toCopy.timestamp.getValue());
        }
        this.columnsToPut.addAll(toCopy.columnsToPut);
    }

    public RowPutChange addColumn(Column column) {
        this.columnsToPut.add(column);
        return this;
    }

    public RowPutChange addColumn(String name, ColumnValue value) {
        Column column = null;
        column = this.timestamp.isValueSet() ? new Column(name, value, this.timestamp.getValue()) : new Column(name, value);
        this.columnsToPut.add(column);
        return this;
    }

    public RowPutChange addColumn(String name, ColumnValue value, long ts) {
        this.columnsToPut.add(new Column(name, value, ts));
        return this;
    }

    public RowPutChange addColumns(List<Column> columns) {
        this.columnsToPut.addAll(columns);
        return this;
    }

    public RowPutChange addColumns(Column[] columns) {
        for (Column column : columns) {
            this.columnsToPut.add(column);
        }
        return this;
    }

    public List<Column> getColumnsToPut() {
        return this.columnsToPut;
    }

    public List<Column> getColumnsToPut(String name) {
        ArrayList<Column> result = new ArrayList<Column>();
        for (Column col : this.columnsToPut) {
            if (!col.getName().equals(name)) continue;
            result.add(col);
        }
        return result;
    }

    @Override
    public int getDataSize() {
        int valueTotalSize = 0;
        for (Column col : this.columnsToPut) {
            valueTotalSize += col.getDataSize();
        }
        return this.getPrimaryKey().getDataSize() + valueTotalSize;
    }

    public boolean has(String name) {
        for (Column col : this.columnsToPut) {
            if (!col.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean has(String name, long ts) {
        for (Column col : this.columnsToPut) {
            if (!col.getName().equals(name) || !col.hasSetTimestamp() || col.getTimestamp() != ts) continue;
            return true;
        }
        return false;
    }

    public boolean has(String name, ColumnValue value) {
        for (Column col : this.columnsToPut) {
            if (!col.getName().equals(name) || !col.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    public boolean has(String name, long ts, ColumnValue value) {
        for (Column col : this.columnsToPut) {
            if (!col.getName().equals(name) || !col.hasSetTimestamp() || col.getTimestamp() != ts || !value.equals(col.getValue())) continue;
            return true;
        }
        return false;
    }
}

