/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.OptionalValue;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.TimeRange;
import com.alicloud.openservices.tablestore.model.filter.Filter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class RowQueryCriteria {
    private String tableName;
    private Set<String> columnsToGet = new HashSet<String>();
    private OptionalValue<TimeRange> timeRange = new OptionalValue("TimeRange");
    private OptionalValue<Integer> maxVersions = new OptionalValue("MaxVersions");
    private OptionalValue<Filter> filter = new OptionalValue("Filter");
    private OptionalValue<String> startColumn = new OptionalValue("StartColumn");
    private OptionalValue<String> endColumn = new OptionalValue("EndColumn");
    private OptionalValue<Boolean> cacheBlocks = new OptionalValue("CacheBlocks");

    public RowQueryCriteria(String tableName) {
        Preconditions.checkArgument(tableName != null && !tableName.isEmpty(), "The name of table should not be null or empty.");
        this.tableName = tableName;
    }

    public void setTableName(String tableName) {
        Preconditions.checkArgument(tableName != null && !tableName.isEmpty(), "The name of table should not be null or empty.");
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Set<String> getColumnsToGet() {
        return Collections.unmodifiableSet(this.columnsToGet);
    }

    public void addColumnsToGet(String columnName) {
        Preconditions.checkArgument(columnName != null && !columnName.isEmpty(), "Column's name should not be null or empty.");
        this.columnsToGet.add(columnName);
    }

    public void addColumnsToGet(String[] columnNames) {
        Preconditions.checkNotNull(columnNames, "columnNames should not be null.");
        for (int i = 0; i < columnNames.length; ++i) {
            this.addColumnsToGet(columnNames[i]);
        }
    }

    public void addColumnsToGet(Collection<String> columnsToGet) {
        this.columnsToGet.addAll(columnsToGet);
    }

    public void clearColumnsToGet() {
        this.columnsToGet.clear();
    }

    public int numColumnsToGet() {
        return this.columnsToGet.size();
    }

    public void setMaxVersions(int maxVersions) {
        Preconditions.checkArgument(maxVersions > 0, "The value of maxVersions must be greater than 0.");
        this.maxVersions.setValue(maxVersions);
    }

    public int getMaxVersions() {
        if (!this.maxVersions.isValueSet()) {
            throw new IllegalStateException("The value of maxVersions is not set.");
        }
        return this.maxVersions.getValue();
    }

    public boolean hasSetMaxVersions() {
        return this.maxVersions.isValueSet();
    }

    public void setTimeRange(TimeRange timeRange) {
        Preconditions.checkNotNull(timeRange, "The time range should not be null.");
        this.timeRange.setValue(timeRange);
    }

    public void setTimestamp(long timestamp) {
        Preconditions.checkArgument(timestamp >= 0L, "The timestamp must be positive.");
        this.timeRange.setValue(new TimeRange(timestamp, timestamp + 1L));
    }

    public TimeRange getTimeRange() {
        if (!this.timeRange.isValueSet()) {
            throw new IllegalStateException("The value of timeRange is not set.");
        }
        return this.timeRange.getValue();
    }

    public boolean hasSetTimeRange() {
        return this.timeRange.isValueSet();
    }

    public void setFilter(Filter filter) {
        Preconditions.checkNotNull(filter, "The filter should not be null");
        this.filter.setValue(filter);
    }

    public Filter getFilter() {
        if (!this.filter.isValueSet()) {
            throw new IllegalStateException("The value of filter is not set.");
        }
        return this.filter.getValue();
    }

    public boolean hasSetFilter() {
        return this.filter.isValueSet();
    }

    public void setCacheBlocks(boolean cacheBlocks) {
        this.cacheBlocks.setValue(cacheBlocks);
    }

    public boolean getCacheBlocks() {
        if (!this.cacheBlocks.isValueSet()) {
            throw new IllegalStateException("The value of cacheBlocks is not set.");
        }
        return this.cacheBlocks.getValue();
    }

    public boolean hasSetCacheBlock() {
        return this.cacheBlocks.isValueSet();
    }

    public String getStartColumn() {
        if (!this.startColumn.isValueSet()) {
            throw new IllegalStateException("The value of startColumn is not set.");
        }
        return this.startColumn.getValue();
    }

    public void setStartColumn(String startColumn) {
        this.startColumn.setValue(startColumn);
    }

    public boolean hasSetStartColumn() {
        return this.startColumn.isValueSet();
    }

    public String getEndColumn() {
        if (!this.endColumn.isValueSet()) {
            throw new IllegalStateException("The value of endColumn is not set.");
        }
        return this.endColumn.getValue();
    }

    public void setEndColumn(String endColumn) {
        this.endColumn.setValue(endColumn);
    }

    public boolean hasSetEndColumn() {
        return this.endColumn.isValueSet();
    }

    public void copyTo(RowQueryCriteria target) {
        target.tableName = this.tableName;
        target.columnsToGet.addAll(this.columnsToGet);
        if (this.timeRange.isValueSet()) {
            target.timeRange.setValue(this.timeRange.getValue());
        }
        if (this.maxVersions.isValueSet()) {
            target.maxVersions.setValue(this.maxVersions.getValue());
        }
        if (this.cacheBlocks.isValueSet()) {
            target.cacheBlocks.setValue(this.cacheBlocks.getValue());
        }
        if (this.filter.isValueSet()) {
            target.filter.setValue(this.filter.getValue());
        }
        if (this.startColumn.isValueSet()) {
            target.startColumn.setValue(this.startColumn.getValue());
        }
        if (this.endColumn.isValueSet()) {
            target.endColumn.setValue(this.endColumn.getValue());
        }
    }
}

