/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search;

import com.alicloud.openservices.tablestore.core.utils.NumberUtils;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.Request;
import com.alicloud.openservices.tablestore.model.search.IndexSchema;
import java.util.concurrent.TimeUnit;

public class CreateSearchIndexRequest
implements Request {
    private String tableName;
    private String indexName;
    private IndexSchema indexSchema;
    private String sourceIndexName;
    private Integer timeToLive;

    public CreateSearchIndexRequest() {
    }

    public CreateSearchIndexRequest(String tableName, String indexName) {
        this.tableName = tableName;
        this.indexName = indexName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public IndexSchema getIndexSchema() {
        return this.indexSchema;
    }

    public void setIndexSchema(IndexSchema indexSchema) {
        this.indexSchema = indexSchema;
    }

    public String getSourceIndexName() {
        return this.sourceIndexName;
    }

    public void setSourceIndexName(String sourceIndexName) {
        this.sourceIndexName = sourceIndexName;
    }

    public Integer getTimeToLive() {
        return this.timeToLive;
    }

    public CreateSearchIndexRequest setTimeToLiveInDays(int days) {
        this.setTimeToLive(days, TimeUnit.DAYS);
        return this;
    }

    public CreateSearchIndexRequest setTimeToLive(int timeToLive, TimeUnit timeUnit) {
        Preconditions.checkArgument(timeToLive > 0 || timeToLive == -1, "The value of timeToLive can be -1 or any positive value.");
        if (timeToLive == -1) {
            this.timeToLive = -1;
        } else {
            long seconds = timeUnit.toSeconds(timeToLive);
            this.timeToLive = NumberUtils.longToInt(seconds);
        }
        return this;
    }

    @Override
    public String getOperationName() {
        return "CreateSearchIndex";
    }
}

