/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search.query;

import com.alicloud.openservices.tablestore.core.protocol.SearchQueryBuilder;
import com.alicloud.openservices.tablestore.model.search.query.InnerHits;
import com.alicloud.openservices.tablestore.model.search.query.Query;
import com.alicloud.openservices.tablestore.model.search.query.QueryBuilder;
import com.alicloud.openservices.tablestore.model.search.query.QueryType;
import com.alicloud.openservices.tablestore.model.search.query.ScoreMode;
import com.aliyun.ots.thirdparty.com.google.protobuf.ByteString;

public class NestedQuery
implements Query {
    private final QueryType queryType = QueryType.QueryType_NestedQuery;
    private String path;
    private Query query;
    private ScoreMode scoreMode;
    private InnerHits innerHits;
    private float weight = 1.0f;

    @Override
    public QueryType getQueryType() {
        return this.queryType;
    }

    @Override
    public ByteString serialize() {
        return SearchQueryBuilder.buildNestedQuery(this).toByteString();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void setInnerHits(InnerHits innerHits) {
        this.innerHits = innerHits;
    }

    public InnerHits getInnerHits() {
        return this.innerHits;
    }

    public ScoreMode getScoreMode() {
        return this.scoreMode;
    }

    public void setScoreMode(ScoreMode scoreMode) {
        this.scoreMode = scoreMode;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    protected static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder
    implements QueryBuilder {
        private String path;
        private Query query;
        private ScoreMode scoreMode;
        private InnerHits innerHits;
        private float weight = 1.0f;

        public Builder weight(float weight) {
            this.weight = weight;
            return this;
        }

        private Builder() {
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder innerHits(InnerHits innerHits) {
            this.innerHits = innerHits;
            return this;
        }

        public Builder query(QueryBuilder queryBuilder) {
            this.query = queryBuilder.build();
            return this;
        }

        public Builder query(Query query) {
            this.query = query;
            return this;
        }

        public Builder scoreMode(ScoreMode scoreMode) {
            this.scoreMode = scoreMode;
            return this;
        }

        @Override
        public NestedQuery build() {
            NestedQuery nestedQuery = new NestedQuery();
            nestedQuery.setPath(this.path);
            nestedQuery.setQuery(this.query);
            nestedQuery.setWeight(this.weight);
            nestedQuery.setScoreMode(this.scoreMode);
            nestedQuery.setInnerHits(this.innerHits);
            return nestedQuery;
        }
    }
}

