/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.reader;

import com.alicloud.openservices.tablestore.AsyncClientInterface;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.reader.PrimaryKeyWithTable;
import com.alicloud.openservices.tablestore.reader.ReaderCallback;
import com.alicloud.openservices.tablestore.reader.ReaderGroup;
import com.alicloud.openservices.tablestore.reader.ReaderStatistics;
import com.alicloud.openservices.tablestore.reader.RowReadResult;
import com.alicloud.openservices.tablestore.reader.TableStoreReaderConfig;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;

public class ReaderCallbackFactory {
    private final AsyncClientInterface ots;
    private final Semaphore callbackSemaphore;
    private final TableStoreCallback<PrimaryKeyWithTable, RowReadResult> callback;
    private final Executor executor;
    private final Semaphore bucketSemaphore;
    private final ReaderStatistics statistics;
    private TableStoreReaderConfig config;

    public ReaderCallbackFactory(AsyncClientInterface ots, Semaphore callbackSemaphore, TableStoreCallback<PrimaryKeyWithTable, RowReadResult> callback, Executor executor, Semaphore bucketSemaphore, ReaderStatistics statistics) {
        this.ots = ots;
        this.callbackSemaphore = callbackSemaphore;
        this.callback = callback;
        this.executor = executor;
        this.bucketSemaphore = bucketSemaphore;
        this.statistics = statistics;
    }

    public TableStoreCallback newInstance(Map<String, List<ReaderGroup>> groupMap) {
        return new ReaderCallback(this.ots, new AtomicInteger(1), this.callbackSemaphore, this.callback, this.executor, this.bucketSemaphore, this.statistics, groupMap);
    }
}

