/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.reader;

import com.alicloud.openservices.tablestore.model.PrimaryKey;
import java.util.concurrent.atomic.AtomicLong;

public class ReaderDispatcher {
    private int bucketCount;
    private final AtomicLong[] bucketDispatchRowCount;

    public ReaderDispatcher(int bucketCount) {
        this.bucketDispatchRowCount = new AtomicLong[bucketCount];
        for (int i = 0; i < bucketCount; ++i) {
            this.bucketDispatchRowCount[i] = new AtomicLong(0L);
        }
        this.bucketCount = bucketCount;
    }

    public int getDispatchIndex(PrimaryKey primaryKey) {
        int bucketIndex = primaryKey.hashCode() % this.bucketCount;
        bucketIndex = (bucketIndex + this.bucketCount) % this.bucketCount;
        this.addBucketCount(bucketIndex);
        return bucketIndex;
    }

    private void addBucketCount(int bucketId) {
        this.bucketDispatchRowCount[bucketId].incrementAndGet();
    }
}

