/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.reader;

import com.alicloud.openservices.tablestore.AsyncClientInterface;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.model.BatchGetRowRequest;
import com.alicloud.openservices.tablestore.model.MultiRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.RowQueryCriteria;
import com.alicloud.openservices.tablestore.reader.PkWithGroup;
import com.alicloud.openservices.tablestore.reader.PrimaryKeyWithTable;
import com.alicloud.openservices.tablestore.reader.ReaderCallbackFactory;
import com.alicloud.openservices.tablestore.reader.ReaderGroup;
import com.alicloud.openservices.tablestore.reader.ReaderStatistics;
import com.alicloud.openservices.tablestore.reader.ReqWithGroups;
import com.alicloud.openservices.tablestore.reader.RowReadResult;
import com.alicloud.openservices.tablestore.reader.TableStoreReaderConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;

public class ReaderRequestManager {
    private final AsyncClientInterface ots;
    private final TableStoreReaderConfig config;
    private final Semaphore callbackSemaphore;
    private final Executor executor;
    private final Semaphore bucketSemaphore;
    private final ReaderStatistics statistics;
    private final Map<String, MultiRowQueryCriteria> criteriaMap;
    private final Map<String, RowQueryCriteria> criteriaSetting;
    private final Map<String, List<ReaderGroup>> groupMap;
    private ReaderCallbackFactory callbackFactory;
    private int totalPksCount;

    public ReaderRequestManager(AsyncClientInterface ots, TableStoreReaderConfig config, Semaphore callbackSemaphore, TableStoreCallback<PrimaryKeyWithTable, RowReadResult> callback, Executor executor, Semaphore bucketSemaphore, ReaderStatistics statistics) {
        this.ots = ots;
        this.config = config;
        this.callbackSemaphore = callbackSemaphore;
        this.executor = executor;
        this.bucketSemaphore = bucketSemaphore;
        this.statistics = statistics;
        this.callbackFactory = new ReaderCallbackFactory(ots, callbackSemaphore, callback, executor, bucketSemaphore, statistics);
        this.totalPksCount = 0;
        this.criteriaMap = new HashMap<String, MultiRowQueryCriteria>();
        this.criteriaSetting = new HashMap<String, RowQueryCriteria>();
        this.groupMap = new HashMap<String, List<ReaderGroup>>();
    }

    public int getTotalPksCount() {
        return this.totalPksCount;
    }

    public ReqWithGroups makeRequest() {
        if (this.criteriaMap.size() > 0) {
            BatchGetRowRequest request = new BatchGetRowRequest();
            for (Map.Entry<String, MultiRowQueryCriteria> entry : this.criteriaMap.entrySet()) {
                request.addMultiRowQueryCriteria(entry.getValue());
            }
            this.criteriaMap.clear();
            this.totalPksCount = 0;
            Map<String, List<ReaderGroup>> groupsCopy = this.deepCopyMap();
            this.groupMap.clear();
            return new ReqWithGroups(request, groupsCopy);
        }
        return null;
    }

    public boolean appendPrimaryKey(PkWithGroup pkWithGroup) {
        String tableName = pkWithGroup.primaryKeyWithTable.getTableName();
        if (this.totalPksCount >= this.config.getMaxBatchRowsCount()) {
            return false;
        }
        this.prepareCriteriaMap(tableName);
        this.criteriaMap.get(tableName).addRow(pkWithGroup.primaryKeyWithTable.getPrimaryKey());
        this.groupMap.get(tableName).add(pkWithGroup.readerGroup);
        ++this.totalPksCount;
        return true;
    }

    public void sendRequest(ReqWithGroups reqWithGroups) {
        BatchGetRowRequest finalRequest = reqWithGroups.getRequest();
        this.ots.batchGetRow(finalRequest, this.callbackFactory.newInstance(reqWithGroups.getGroupMap()));
    }

    public void setRowQueryCriteria(RowQueryCriteria rowQueryCriteria) {
        String tableName = rowQueryCriteria.getTableName();
        this.criteriaSetting.put(tableName, rowQueryCriteria);
        if (this.criteriaMap.containsKey(tableName)) {
            this.criteriaMap.get(tableName).clearColumnsToGet();
            rowQueryCriteria.copyTo(this.criteriaMap.get(tableName));
        }
    }

    public void setCallback(TableStoreCallback<PrimaryKeyWithTable, RowReadResult> callback) {
        this.callbackFactory = new ReaderCallbackFactory(this.ots, this.callbackSemaphore, callback, this.executor, this.bucketSemaphore, this.statistics);
    }

    private void prepareCriteriaMap(String tableName) {
        if (!this.criteriaMap.containsKey(tableName)) {
            MultiRowQueryCriteria multiRowQueryCriteria = new MultiRowQueryCriteria(tableName);
            multiRowQueryCriteria.setMaxVersions(this.config.getDefaultMaxVersions());
            if (this.criteriaSetting.containsKey(tableName)) {
                multiRowQueryCriteria.clearColumnsToGet();
                this.criteriaSetting.get(tableName).copyTo(multiRowQueryCriteria);
            }
            this.criteriaMap.put(tableName, multiRowQueryCriteria);
        }
        if (!this.groupMap.containsKey(tableName)) {
            this.groupMap.put(tableName, new ArrayList());
        }
    }

    private Map<String, List<ReaderGroup>> deepCopyMap() {
        HashMap<String, List<ReaderGroup>> copy = new HashMap<String, List<ReaderGroup>>();
        for (Map.Entry<String, List<ReaderGroup>> entry : this.groupMap.entrySet()) {
            copy.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return copy;
    }
}

