/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timeserieswriter.dispatch;

import com.alicloud.openservices.tablestore.model.timeseries.TimeseriesRow;
import com.alicloud.openservices.tablestore.timeserieswriter.dispatch.TimeseriesBaseDispatcher;
import java.util.concurrent.atomic.AtomicLong;

public class TimeseriesRoundRobinDispatcher
extends TimeseriesBaseDispatcher {
    private AtomicLong counter = new AtomicLong(0L);
    private int bucketCount;

    public TimeseriesRoundRobinDispatcher(int bucketCount) {
        super(bucketCount);
        this.bucketCount = bucketCount;
    }

    @Override
    public int getDispatchIndex(TimeseriesRow timeseriesRow) {
        int bucketIndex = (int)this.counter.getAndIncrement() % this.bucketCount;
        this.addBucketCount(bucketIndex);
        return bucketIndex;
    }
}

