/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timestream.model;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.timestream.model.annotation.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Point {
    private static Logger logger = LoggerFactory.getLogger(Point.class);
    private long timestamp;
    private List<Column> fieldList;

    protected Point(Row row) {
        this.timestamp = row.getPrimaryKey().getPrimaryKeyColumn("s").getValue().asLong();
        this.fieldList = new ArrayList<Column>();
        this.addField(row);
    }

    private Point(long timestamp, TimeUnit unit) {
        this.timestamp = unit.toMicros(timestamp);
        this.fieldList = new ArrayList<Column>();
    }

    protected Point(long timestamp, TimeUnit unit, Row row) {
        this.timestamp = unit.toMicros(timestamp);
        this.fieldList = new ArrayList<Column>();
        this.addField(row);
    }

    public long getTimestamp() {
        return this.getTimestamp(TimeUnit.MICROSECONDS);
    }

    public long getTimestamp(TimeUnit unit) {
        return unit.convert(this.timestamp, TimeUnit.MICROSECONDS);
    }

    protected Point addField(Column col) {
        this.fieldList.add(col);
        return this;
    }

    private Point setFields(List<Column> cols) {
        this.fieldList = cols;
        return this;
    }

    public List<Column> getFields() {
        return this.fieldList;
    }

    public ColumnValue getField(String name) {
        ColumnValue value = null;
        for (Column col : this.fieldList) {
            if (!col.getName().equals(name)) continue;
            value = col.getValue();
        }
        return value;
    }

    private void addField(Row row) {
        for (Map.Entry e : row.getColumnsMap().entrySet()) {
            this.fieldList.add(row.getLatestColumn((String)e.getKey()));
        }
    }

    public String toString() {
        HashMap<String, String> fields = new HashMap<String, String>();
        for (Column col : this.fieldList) {
            fields.put(col.getName(), col.getValue().toString());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("timestamp=").append(this.timestamp).append(", ");
        sb.append("fileds=").append(fields);
        return sb.toString();
    }

    public static final class Builder {
        private long timestamp;
        private List<Column> fieldList;

        public Builder(long timestamp, TimeUnit unit) {
            if (timestamp < 0L) {
                throw new ClientException("The timestamp must be positive.");
            }
            this.timestamp = unit.toMicros(timestamp);
            this.fieldList = new ArrayList<Column>();
        }

        public Builder addField(String key, float value) {
            this.fieldList.add(new Column(key, ColumnValue.fromDouble(value)));
            return this;
        }

        public Builder addField(String key, double value) {
            this.fieldList.add(new Column(key, ColumnValue.fromDouble(value)));
            return this;
        }

        public Builder addField(String key, int value) {
            this.fieldList.add(new Column(key, ColumnValue.fromLong(value)));
            return this;
        }

        public Builder addField(String key, long value) {
            this.fieldList.add(new Column(key, ColumnValue.fromLong(value)));
            return this;
        }

        public Builder addField(String key, String value) {
            this.fieldList.add(new Column(key, ColumnValue.fromString(value)));
            return this;
        }

        public Builder addField(String key, boolean value) {
            this.fieldList.add(new Column(key, ColumnValue.fromBoolean(value)));
            return this;
        }

        private Builder addField(String key, Object value) {
            if (value instanceof String) {
                this.addField(key, (String)value);
            } else if (value instanceof Double) {
                this.addField(key, (Double)value);
            } else if (value instanceof Float) {
                this.addField(key, ((Float)value).floatValue());
            } else if (value instanceof Long) {
                this.addField(key, (Long)value);
            } else if (value instanceof Integer) {
                this.addField(key, (Integer)value);
            } else if (value instanceof Boolean) {
                this.addField(key, (Boolean)value);
            } else {
                throw new ClientException("Unsupported type, must be String/Double/Float/Long/Integer/Boolean");
            }
            return this;
        }

        public Builder from(Object object) {
            try {
                Class<?> c = object.getClass();
                for (java.lang.reflect.Field field : c.getFields()) {
                    Field colAnnotation = field.getAnnotation(Field.class);
                    if (colAnnotation == null) continue;
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    this.addField(colAnnotation.name(), field.get(object));
                }
            }
            catch (IllegalAccessException e) {
                throw new ClientException(e.toString());
            }
            return this;
        }

        public Point build() {
            Point point = new Point(this.timestamp, TimeUnit.MICROSECONDS);
            point.setFields(this.fieldList);
            return point;
        }
    }
}

