/*
 * Copyright 2010-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package com.amazonaws.services.s3.model.ownership;

import java.io.Serializable;
import java.util.List;

/**
 * <p>The container element for a bucket's ownership controls.</p>
 */
public class OwnershipControls implements Serializable {

    private List<OwnershipControlsRule> rules;

    public List<OwnershipControlsRule> getRules() {
        return rules;
    }

    public void setRules(List<OwnershipControlsRule> rules) {
        this.rules = rules;
    }

    public OwnershipControls withRules(List<OwnershipControlsRule> rules) {
        setRules(rules);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        OwnershipControls that = (OwnershipControls) o;

        return rules != null ? rules.equals(that.rules) : that.rules == null;
    }

    @Override
    public int hashCode() {
        return rules != null ? rules.hashCode() : 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getRules() != null) {
            sb.append("Rules: ").append(getRules()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }
}
