/*
 * Decompiled with CFR 0.152.
 */
package mybatis.mate.databind;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Objects;
import mybatis.mate.annotation.FieldSensitive;
import mybatis.mate.databind.ISensitiveStrategy;
import mybatis.mate.databind.JsonContextualSerializer;
import mybatis.mate.databind.RequestDataTransfer;

public class SensitiveSerializer
extends JsonSerializer<String>
implements JsonContextualSerializer {
    private static ISensitiveStrategy SENSITIVE_STRATEGY;
    private String type;

    public SensitiveSerializer() {
    }

    public SensitiveSerializer(String type) {
        this.type = type;
    }

    public static void setSensitiveStrategy(ISensitiveStrategy sensitiveStrategy) {
        SENSITIVE_STRATEGY = sensitiveStrategy;
    }

    public void serialize(String value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (null == SENSITIVE_STRATEGY) {
            throw new RuntimeException("You used the annotation `@FieldSensitive` but did not inject `SensitiveStrategy`");
        }
        String fieldValue = null;
        Object fieldNames = RequestDataTransfer.get(RequestDataTransfer.SKIP_SENSITIVE);
        if (Objects.equals("_all_", fieldNames)) {
            fieldValue = value;
        } else {
            String currentName;
            JsonStreamContext jsc;
            if (null != fieldNames && null != (jsc = gen.getOutputContext()) && null != (currentName = jsc.getCurrentName()) && ((String)fieldNames).contains(currentName)) {
                fieldValue = value;
            }
            if (null == fieldValue) {
                fieldValue = SENSITIVE_STRATEGY.handle(this.type, value);
            }
        }
        gen.writeObject((Object)fieldValue);
    }

    @Override
    public JsonSerializer<?> getJsonSerializer(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        FieldSensitive sensitiveInfo;
        if (Objects.equals(property.getType().getRawClass(), String.class) && null != (sensitiveInfo = (FieldSensitive)this.getAnnotation(property, FieldSensitive.class))) {
            return new SensitiveSerializer(sensitiveInfo.value());
        }
        return provider.findValueSerializer(property.getType(), property);
    }
}

