/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core;

import com.baomidou.mybatisplus.core.MybatisMapperRegistry;
import com.baomidou.mybatisplus.core.MybatisXMLLanguageDriver;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import org.apache.ibatis.binding.MapperRegistry;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;

public class MybatisConfiguration
extends Configuration {
    private static final Log logger = LogFactory.getLog(MybatisConfiguration.class);
    public final MybatisMapperRegistry mybatisMapperRegistry = new MybatisMapperRegistry(this);

    public MybatisConfiguration() {
        this.setDefaultScriptingLanguage(MybatisXMLLanguageDriver.class);
        System.out.println("___  ___       ______         _    _        ______  _             ");
        System.out.println("|  \\/  |       | ___ \\       | |  (_)       | ___ \\| |            ");
        System.out.println("| .  . | _   _ | |_/ /  __ _ | |_  _  ___   | |_/ /| | _   _  ___ ");
        System.out.println("| |\\/| || | | || ___ \\ / _` || __|| |/ __|  |  __/ | || | | |/ __|");
        System.out.println("| |  | || |_| || |_/ /| (_| || |_ | |\\__ \\  | |    | || |_| |\\__ \\");
        System.out.println("\\_|  |_/ \\__, |\\____/  \\__,_| \\__||_||___/  \\_|    |_| \\__,_||___/");
        System.out.println("          __/ |                                                   ");
        System.out.println("         |___/                                             3.0-RC1");
        System.out.println();
    }

    public void addMappedStatement(MappedStatement ms) {
        logger.debug("addMappedStatement: " + ms.getId());
        if (GlobalConfigUtils.isRefresh(ms.getConfiguration())) {
            this.mappedStatements.remove(ms.getId());
        } else if (this.mappedStatements.containsKey(ms.getId())) {
            logger.error("mapper[" + ms.getId() + "] is ignored, because it exists, maybe from xml file");
            return;
        }
        super.addMappedStatement(ms);
    }

    public void setDefaultScriptingLanguage(Class<?> driver) {
        if (driver == null) {
            driver = MybatisXMLLanguageDriver.class;
        }
        super.setDefaultScriptingLanguage(driver);
    }

    public MapperRegistry getMapperRegistry() {
        return this.mybatisMapperRegistry;
    }

    public <T> void addMapper(Class<T> type) {
        this.mybatisMapperRegistry.addMapper(type);
    }

    public void addMappers(String packageName, Class<?> superType) {
        this.mybatisMapperRegistry.addMappers(packageName, superType);
    }

    public void addMappers(String packageName) {
        this.mybatisMapperRegistry.addMappers(packageName);
    }

    public <T> T getMapper(Class<T> type, SqlSession sqlSession) {
        return this.mybatisMapperRegistry.getMapper(type, sqlSession);
    }

    public boolean hasMapper(Class<?> type) {
        return this.mybatisMapperRegistry.hasMapper(type);
    }
}

