/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.toolkit;

import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.ColumnCache;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.core.toolkit.support.SerializedLambda;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public final class LambdaUtils {
    private static final Map<String, Map<String, ColumnCache>> LAMBDA_CACHE = new ConcurrentHashMap<String, Map<String, ColumnCache>>();
    private static final Map<Class, WeakReference<SerializedLambda>> FUNC_CACHE = new ConcurrentHashMap<Class, WeakReference<SerializedLambda>>();

    public static <T> SerializedLambda resolve(SFunction<T, ?> func) {
        Class<?> clazz = func.getClass();
        return Optional.ofNullable(FUNC_CACHE.get(clazz)).map(Reference::get).orElseGet(() -> {
            SerializedLambda lambda = SerializedLambda.resolve(func);
            FUNC_CACHE.put(clazz, new WeakReference<SerializedLambda>(lambda));
            return lambda;
        });
    }

    public static void createCache(Class clazz, TableInfo tableInfo) {
        LAMBDA_CACHE.put(clazz.getName(), LambdaUtils.createLambdaMap(tableInfo, clazz));
    }

    private static void saveCache(String className, String property, ColumnCache columnCache) {
        Map cacheMap = LAMBDA_CACHE.getOrDefault(className, new HashMap());
        cacheMap.put(property, columnCache);
        LAMBDA_CACHE.put(className, cacheMap);
    }

    private static Map<String, ColumnCache> createLambdaMap(TableInfo tableInfo, Class clazz) {
        HashMap<String, ColumnCache> map = new HashMap<String, ColumnCache>();
        String keyProperty = tableInfo.getKeyProperty();
        if (StringUtils.isNotEmpty(keyProperty)) {
            keyProperty = keyProperty.toUpperCase(Locale.ENGLISH);
            String keyColumn = tableInfo.getKeyColumn();
            String keySelect = tableInfo.getSqlSelect();
            ColumnCache cache = new ColumnCache(keyColumn, keySelect);
            if (tableInfo.getClazz() != clazz) {
                LambdaUtils.saveCache(tableInfo.getClazz().getName(), keyProperty, cache);
            }
            map.put(keyProperty, cache);
        }
        tableInfo.getFieldList().forEach(i -> {
            String property = i.getProperty().toUpperCase(Locale.ENGLISH);
            String column = i.getColumn();
            String columnSelect = i.getSqlSelect(tableInfo.getDbType());
            ColumnCache cache = new ColumnCache(column, columnSelect);
            if (i.getClazz() != clazz) {
                LambdaUtils.saveCache(i.getClazz().getName(), property, cache);
            }
            map.put(property, cache);
        });
        return map;
    }

    public static Map<String, ColumnCache> getColumnMap(String entityClassName) {
        return LAMBDA_CACHE.getOrDefault(entityClassName, Collections.emptyMap());
    }
}

