/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.java;

import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseConfig;
import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseFramework;
import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipsePluginConfig;
import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseServiceConfig;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.osgi.framework.BundleActivator;

public class EclipseJdtFormatterStepImpl {
    private final CodeFormatter codeFormatter;

    public EclipseJdtFormatterStepImpl(Properties settings) throws Exception {
        SpotlessEclipseFramework.setup((SpotlessEclipseConfig)new FrameworkConfig());
        this.codeFormatter = ToolFactory.createCodeFormatter((Map)settings, (int)ToolFactory.M_FORMAT_EXISTING);
    }

    public String format(String raw) throws Exception {
        return this.format(raw, new File(""));
    }

    public String format(String raw, File file) throws Exception {
        int kind = (file.getName().equals("module-info.java") ? 128 : 8) | 0x1000;
        TextEdit edit = this.codeFormatter.format(kind, raw, 0, raw.length(), 0, "\n");
        if (edit == null) {
            throw new IllegalArgumentException("Invalid java syntax for formatting.");
        }
        Document doc = new Document(raw);
        edit.apply((IDocument)doc);
        return doc.get();
    }

    private static class FrameworkConfig
    implements SpotlessEclipseConfig {
        private FrameworkConfig() {
        }

        public void registerServices(SpotlessEclipseServiceConfig config) {
            config.applyDefault();
            config.useSlf4J(EclipseJdtFormatterStepImpl.class.getPackage().getName());
        }

        public void activatePlugins(SpotlessEclipsePluginConfig config) {
            config.applyDefault();
            config.add((BundleActivator)new JavaCore());
        }
    }
}

