/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Storage;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Table {
    private final String databaseName;
    private final String tableName;
    private final String owner;
    private final String tableType;
    private final List<Column> dataColumns;
    private final List<Column> partitionColumns;
    private final Storage storage;
    private final Map<String, String> parameters;
    private final Optional<String> viewOriginalText;
    private final Optional<String> viewExpandedText;

    @JsonCreator
    public Table(@JsonProperty(value="databaseName") String databaseName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="owner") String owner, @JsonProperty(value="tableType") String tableType, @JsonProperty(value="storage") Storage storage, @JsonProperty(value="dataColumns") List<Column> dataColumns, @JsonProperty(value="partitionColumns") List<Column> partitionColumns, @JsonProperty(value="parameters") Map<String, String> parameters, @JsonProperty(value="viewOriginalText") Optional<String> viewOriginalText, @JsonProperty(value="viewExpandedText") Optional<String> viewExpandedText) {
        this.databaseName = Objects.requireNonNull(databaseName, "databaseName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.owner = Objects.requireNonNull(owner, "owner is null");
        this.tableType = Objects.requireNonNull(tableType, "tableType is null");
        this.storage = Objects.requireNonNull(storage, "storage is null");
        this.dataColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(dataColumns, "dataColumns is null"));
        this.partitionColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionColumns, "partitionColumns is null"));
        this.parameters = ImmutableMap.copyOf(Objects.requireNonNull(parameters, "parameters is null"));
        this.viewOriginalText = Objects.requireNonNull(viewOriginalText, "viewOriginalText is null");
        this.viewExpandedText = Objects.requireNonNull(viewExpandedText, "viewExpandedText is null");
    }

    @JsonProperty
    public String getDatabaseName() {
        return this.databaseName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public String getOwner() {
        return this.owner;
    }

    @JsonProperty
    public String getTableType() {
        return this.tableType;
    }

    @JsonProperty
    public List<Column> getDataColumns() {
        return this.dataColumns;
    }

    @JsonProperty
    public List<Column> getPartitionColumns() {
        return this.partitionColumns;
    }

    public Optional<Column> getColumn(String name) {
        return Stream.concat(this.partitionColumns.stream(), this.dataColumns.stream()).filter(column -> column.getName().equals(name)).findFirst();
    }

    @JsonProperty
    public Storage getStorage() {
        return this.storage;
    }

    @JsonProperty
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @JsonProperty
    public Optional<String> getViewOriginalText() {
        return this.viewOriginalText;
    }

    @JsonProperty
    public Optional<String> getViewExpandedText() {
        return this.viewExpandedText;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("databaseName", (Object)this.databaseName).add("tableName", (Object)this.tableName).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Table table) {
        return new Builder(table);
    }

    public static class Builder {
        private final Storage.Builder storageBuilder;
        private String databaseName;
        private String tableName;
        private String owner;
        private String tableType;
        private List<Column> dataColumns = new ArrayList<Column>();
        private List<Column> partitionColumns = new ArrayList<Column>();
        private Map<String, String> parameters = new LinkedHashMap<String, String>();
        private Optional<String> viewOriginalText = Optional.empty();
        private Optional<String> viewExpandedText = Optional.empty();

        private Builder() {
            this.storageBuilder = Storage.builder();
        }

        private Builder(Table table) {
            this.databaseName = table.databaseName;
            this.tableName = table.tableName;
            this.owner = table.owner;
            this.tableType = table.tableType;
            this.storageBuilder = Storage.builder(table.getStorage());
            this.dataColumns = new ArrayList<Column>(table.dataColumns);
            this.partitionColumns = new ArrayList<Column>(table.partitionColumns);
            this.parameters = new LinkedHashMap<String, String>(table.parameters);
            this.viewOriginalText = table.viewOriginalText;
            this.viewExpandedText = table.viewExpandedText;
        }

        public Builder setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder setOwner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder setTableType(String tableType) {
            this.tableType = tableType;
            return this;
        }

        public Storage.Builder getStorageBuilder() {
            return this.storageBuilder;
        }

        public Builder setDataColumns(List<Column> dataColumns) {
            this.dataColumns = new ArrayList<Column>(dataColumns);
            return this;
        }

        public Builder addDataColumn(Column dataColumn) {
            this.dataColumns.add(dataColumn);
            return this;
        }

        public Builder setPartitionColumns(List<Column> partitionColumns) {
            this.partitionColumns = new ArrayList<Column>(partitionColumns);
            return this;
        }

        public Builder setParameters(Map<String, String> parameters) {
            this.parameters = new LinkedHashMap<String, String>(parameters);
            return this;
        }

        public Builder setViewOriginalText(Optional<String> viewOriginalText) {
            this.viewOriginalText = viewOriginalText;
            return this;
        }

        public Builder setViewExpandedText(Optional<String> viewExpandedText) {
            this.viewExpandedText = viewExpandedText;
            return this;
        }

        public Builder withStorage(Consumer<Storage.Builder> consumer) {
            consumer.accept(this.storageBuilder);
            return this;
        }

        public Table build() {
            return new Table(this.databaseName, this.tableName, this.owner, this.tableType, this.storageBuilder.build(), this.dataColumns, this.partitionColumns, this.parameters, this.viewOriginalText, this.viewExpandedText);
        }
    }
}

