/*
 * Decompiled with CFR 0.152.
 */
package com.getui.push.v2.sdk.core.factory;

import com.getui.push.v2.sdk.anno.param.GtBodyParam;
import com.getui.push.v2.sdk.anno.param.GtPathParam;
import com.getui.push.v2.sdk.anno.param.GtQueryParam;
import com.getui.push.v2.sdk.common.ApiException;
import com.getui.push.v2.sdk.common.Assert;
import com.getui.push.v2.sdk.common.util.Utils;
import com.getui.push.v2.sdk.core.client.DefaultApiClient;
import com.getui.push.v2.sdk.core.registry.DefaultGtApiRegistry;
import com.getui.push.v2.sdk.core.registry.GtApiRegistry;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class GtApiProxyFactory
implements InvocationHandler {
    private static ConcurrentMap<DefaultApiClient, GtApiProxyFactory> cache = new ConcurrentHashMap<DefaultApiClient, GtApiProxyFactory>(2);
    DefaultApiClient defaultApiClient;
    private GtApiRegistry gtApiRegistry;

    public void setGtApiRegistry(GtApiRegistry gtApiRegistry) {
        this.gtApiRegistry = gtApiRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GtApiProxyFactory build(DefaultApiClient defaultApiClient) {
        GtApiProxyFactory gtApiProxyFactory = (GtApiProxyFactory)cache.get(defaultApiClient);
        if (gtApiProxyFactory == null) {
            ConcurrentMap<DefaultApiClient, GtApiProxyFactory> concurrentMap = cache;
            synchronized (concurrentMap) {
                gtApiProxyFactory = new GtApiProxyFactory(defaultApiClient);
                cache.put(defaultApiClient, gtApiProxyFactory);
            }
        }
        return gtApiProxyFactory;
    }

    private GtApiProxyFactory(DefaultApiClient defaultApiClient) {
        if (defaultApiClient == null) {
            throw new ApiException("defaultApiClient cannot be null.", true);
        }
        this.defaultApiClient = defaultApiClient;
        this.gtApiRegistry = new DefaultGtApiRegistry();
    }

    public <T> T createProxy(Class<T> apiService) {
        return (T)Proxy.newProxyInstance(apiService.getClassLoader(), new Class[]{apiService}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        if ("toString".equalsIgnoreCase(method.getName()) && Utils.isEmpty(args)) {
            return this.toString();
        }
        ApiParam apiParam = this.gtApiRegistry.get(method);
        this.handleApiParam(method, args, apiParam);
        return this.defaultApiClient.execute(apiParam);
    }

    private void handleApiParam(Method method, Object[] args, ApiParam apiParam) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (Annotation annotation : parameterAnnotations[i]) {
                if (annotation instanceof GtPathParam) {
                    apiParam.handlePathParam(args[i]);
                    continue;
                }
                if (annotation instanceof GtQueryParam) {
                    apiParam.handleQueryParam(args[i], ((GtQueryParam)annotation).name());
                    continue;
                }
                if (!(annotation instanceof GtBodyParam)) continue;
                apiParam.setBody(args[i]);
            }
        }
    }

    public void close() {
        this.defaultApiClient.close();
        cache.remove(this.defaultApiClient);
    }

    public static class ApiParam {
        private String uri;
        private String method;
        private String pathParams;
        private List<String> queryParams;
        private Object body;
        private Boolean needToken;
        private Type returnType;

        public void handlePathParam(Object arg) {
            Assert.notNull(arg, "\u8def\u5f84\u53c2\u6570");
            this.setPathParams(this.handleArg(arg));
        }

        public void handleQueryParam(Object arg, String name) {
            Assert.notNull(arg, "query\u53c2\u6570");
            String param = this.handleArg(arg);
            this.addQueryParams(name, param);
        }

        private void addQueryParams(String name, String param) {
            if (this.queryParams == null) {
                this.queryParams = new ArrayList<String>();
            }
            this.queryParams.add(name + "=" + param);
        }

        private String handleArg(Object arg) {
            if (arg instanceof Iterable) {
                Iterator iterator = ((Iterable)arg).iterator();
                StringBuilder sb = new StringBuilder();
                while (iterator.hasNext()) {
                    sb.append(iterator.next()).append(',');
                }
                String param = sb.toString();
                if (param.endsWith(",")) {
                    param = param.substring(0, param.length() - 1);
                }
                return param;
            }
            if (arg instanceof Number) {
                return arg.toString();
            }
            if (arg instanceof String) {
                return (String)arg;
            }
            throw new ApiException("\u8def\u5f84\u53c2\u6570(\u52a0GtPathParam\u6ce8\u89e3\u7684\u53c2\u6570)\u548cquery\u53c2\u6570(\u52a0GtQueryParam\u6ce8\u89e3\u7684\u53c2\u6570)\u53ea\u80fd\u4e3a Iterable/Number/String\u7684\u4e09\u79cd\u7c7b\u578b\u6216\u5176\u5b50\u7c7b\u578b");
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public String getPathParams() {
            return this.pathParams;
        }

        public void setPathParams(String pathParams) {
            this.pathParams = pathParams;
        }

        public List<String> getQueryParams() {
            return this.queryParams;
        }

        public void setQueryParams(List<String> queryParams) {
            this.queryParams = queryParams;
        }

        public Object getBody() {
            return this.body;
        }

        public void setBody(Object body) {
            this.body = body;
        }

        public Boolean getNeedToken() {
            return this.needToken;
        }

        public void setNeedToken(Boolean needToken) {
            this.needToken = needToken;
        }

        public Type getReturnType() {
            return this.returnType;
        }

        public void setReturnType(Type returnType) {
            this.returnType = returnType;
        }

        public String toString() {
            return "ApiParam{uri='" + this.uri + '\'' + ", method='" + this.method + '\'' + ", pathParams='" + this.pathParams + '\'' + ", body=" + this.body + ", needToken=" + this.needToken + ", returnType=" + this.returnType + '}';
        }
    }
}

