/*
 * Decompiled with CFR 0.152.
 */
package com.github.crab2died;

import com.github.crab2died.converter.DefaultConvertible;
import com.github.crab2died.exceptions.Excel4jReadException;
import com.github.crab2died.handler.ExcelHeader;
import com.github.crab2died.handler.ExcelTemplate;
import com.github.crab2died.utils.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtils {
    private static ExcelUtils excelUtils = new ExcelUtils();

    private ExcelUtils() {
    }

    public static ExcelUtils getInstance() {
        return excelUtils;
    }

    public <T> List<T> readExcel2Objects(String excelPath, Class<T> clazz, int offsetLine, int limitLine, int sheetIndex) throws Exception {
        Workbook workbook = WorkbookFactory.create((File)new File(excelPath));
        return this.readExcel2ObjectsHandler(workbook, clazz, offsetLine, limitLine, sheetIndex);
    }

    public <T> List<T> readExcel2Objects(InputStream is, Class<T> clazz, int offsetLine, int limitLine, int sheetIndex) throws Exception {
        Workbook workbook = WorkbookFactory.create((InputStream)is);
        return this.readExcel2ObjectsHandler(workbook, clazz, offsetLine, limitLine, sheetIndex);
    }

    public <T> List<T> readExcel2Objects(String excelPath, Class<T> clazz, int offsetLine, int sheetIndex) throws Exception {
        return this.readExcel2Objects(excelPath, clazz, offsetLine, Integer.MAX_VALUE, sheetIndex);
    }

    public <T> List<T> readExcel2Objects(String excelPath, Class<T> clazz, int sheetIndex) throws Exception {
        return this.readExcel2Objects(excelPath, clazz, 0, Integer.MAX_VALUE, sheetIndex);
    }

    public <T> List<T> readExcel2Objects(String excelPath, Class<T> clazz) throws Exception {
        return this.readExcel2Objects(excelPath, clazz, 0, Integer.MAX_VALUE, 0);
    }

    public <T> List<T> readExcel2Objects(InputStream is, Class<T> clazz, int sheetIndex) throws Exception {
        return this.readExcel2Objects(is, clazz, 0, Integer.MAX_VALUE, sheetIndex);
    }

    public <T> List<T> readExcel2Objects(InputStream is, Class<T> clazz) throws Exception {
        return this.readExcel2Objects(is, clazz, 0, Integer.MAX_VALUE, 0);
    }

    private <T> List<T> readExcel2ObjectsHandler(Workbook workbook, Class<T> clazz, int offsetLine, int limitLine, int sheetIndex) throws Exception {
        Sheet sheet = workbook.getSheetAt(sheetIndex);
        Row row = sheet.getRow(offsetLine);
        ArrayList<T> list = new ArrayList<T>();
        Map<Integer, ExcelHeader> maps = Utils.getHeaderMap(row, clazz);
        if (maps == null || maps.size() <= 0) {
            throw new Excel4jReadException("The Excel format to read is not correct, and check to see if the appropriate rows are set");
        }
        long maxLine = (long)sheet.getLastRowNum() > (long)offsetLine + (long)limitLine ? (long)offsetLine + (long)limitLine : (long)sheet.getLastRowNum();
        int i = offsetLine + 1;
        while ((long)i <= maxLine) {
            row = sheet.getRow(i);
            T obj = clazz.newInstance();
            for (Cell cell : row) {
                int ci = cell.getColumnIndex();
                ExcelHeader header = maps.get(ci);
                if (null == header) continue;
                String val = Utils.getCellValue(cell);
                String filed = header.getFiled();
                Object value = null != header.getReadConverter() && header.getReadConverter().getClass() != DefaultConvertible.class ? header.getReadConverter().execRead(val) : Utils.str2TargetClass(val, header.getFiledClazz());
                Utils.copyProperty(obj, filed, value);
            }
            list.add(obj);
            ++i;
        }
        return list;
    }

    public List<List<String>> readExcel2List(String excelPath, int offsetLine, int limitLine, int sheetIndex) throws Exception {
        Workbook workbook = WorkbookFactory.create((File)new File(excelPath));
        return this.readExcel2ObjectsHandler(workbook, offsetLine, limitLine, sheetIndex);
    }

    public List<List<String>> readExcel2List(InputStream is, int offsetLine, int limitLine, int sheetIndex) throws Exception {
        Workbook workbook = WorkbookFactory.create((InputStream)is);
        return this.readExcel2ObjectsHandler(workbook, offsetLine, limitLine, sheetIndex);
    }

    public List<List<String>> readExcel2List(String excelPath, int offsetLine) throws Exception {
        Workbook workbook = WorkbookFactory.create((File)new File(excelPath));
        return this.readExcel2ObjectsHandler(workbook, offsetLine, Integer.MAX_VALUE, 0);
    }

    public List<List<String>> readExcel2List(InputStream is, int offsetLine) throws Exception {
        Workbook workbook = WorkbookFactory.create((InputStream)is);
        return this.readExcel2ObjectsHandler(workbook, offsetLine, Integer.MAX_VALUE, 0);
    }

    public List<List<String>> readExcel2List(String excelPath) throws Exception {
        Workbook workbook = WorkbookFactory.create((File)new File(excelPath));
        return this.readExcel2ObjectsHandler(workbook, 0, Integer.MAX_VALUE, 0);
    }

    public List<List<String>> readExcel2List(InputStream is) throws Exception {
        Workbook workbook = WorkbookFactory.create((InputStream)is);
        return this.readExcel2ObjectsHandler(workbook, 0, Integer.MAX_VALUE, 0);
    }

    private List<List<String>> readExcel2ObjectsHandler(Workbook workbook, int offsetLine, int limitLine, int sheetIndex) throws Exception {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        Sheet sheet = workbook.getSheetAt(sheetIndex);
        long maxLine = (long)sheet.getLastRowNum() > (long)offsetLine + (long)limitLine ? (long)offsetLine + (long)limitLine : (long)sheet.getLastRowNum();
        int i = offsetLine;
        while ((long)i < maxLine) {
            ArrayList<String> rows = new ArrayList<String>();
            Row row = sheet.getRow(i);
            for (Cell cell : row) {
                String val = Utils.getCellValue(cell);
                rows.add(val);
            }
            list.add(rows);
            ++i;
        }
        return list;
    }

    public void exportObjects2Excel(String templatePath, int sheetIndex, List<?> data, Map<String, String> extendMap, Class clazz, boolean isWriteHeader, String targetPath) throws Exception {
        this.exportExcelByModuleHandler(templatePath, sheetIndex, data, extendMap, clazz, isWriteHeader).write2File(targetPath);
    }

    public void exportObjects2Excel(String templatePath, int sheetIndex, List<?> data, Map<String, String> extendMap, Class clazz, boolean isWriteHeader, OutputStream os) throws Exception {
        this.exportExcelByModuleHandler(templatePath, sheetIndex, data, extendMap, clazz, isWriteHeader).write2Stream(os);
    }

    public void exportObjects2Excel(String templatePath, List<?> data, Map<String, String> extendMap, Class clazz, boolean isWriteHeader, String targetPath) throws Exception {
        this.exportObjects2Excel(templatePath, 0, data, extendMap, clazz, isWriteHeader, targetPath);
    }

    public void exportObjects2Excel(String templatePath, List<?> data, Map<String, String> extendMap, Class clazz, boolean isWriteHeader, OutputStream os) throws Exception {
        this.exportObjects2Excel(templatePath, 0, data, extendMap, clazz, isWriteHeader, os);
    }

    public void exportObjects2Excel(String templatePath, List<?> data, Map<String, String> extendMap, Class clazz, String targetPath) throws Exception {
        this.exportObjects2Excel(templatePath, 0, data, extendMap, clazz, false, targetPath);
    }

    public void exportObjects2Excel(String templatePath, List<?> data, Map<String, String> extendMap, Class clazz, OutputStream os) throws Exception {
        this.exportObjects2Excel(templatePath, 0, data, extendMap, clazz, false, os);
    }

    public void exportObjects2Excel(String templatePath, List<?> data, Class clazz, String targetPath) throws Exception {
        this.exportObjects2Excel(templatePath, 0, data, null, clazz, false, targetPath);
    }

    public void exportObjects2Excel(String templatePath, List<?> data, Class clazz, OutputStream os) throws Exception {
        this.exportObjects2Excel(templatePath, 0, data, null, clazz, false, os);
    }

    private ExcelTemplate exportExcelByModuleHandler(String templatePath, int sheetIndex, List<?> data, Map<String, String> extendMap, Class clazz, boolean isWriteHeader) throws Exception {
        ExcelTemplate templates = ExcelTemplate.getInstance(templatePath, sheetIndex);
        templates.extendData(extendMap);
        List<ExcelHeader> headers = Utils.getHeaderList(clazz);
        if (isWriteHeader) {
            templates.createNewRow();
            for (ExcelHeader header : headers) {
                templates.createCell(header.getTitle(), null);
            }
        }
        for (Object object : data) {
            templates.createNewRow();
            templates.insertSerial(null);
            for (ExcelHeader header : headers) {
                templates.createCell(Utils.getProperty(object, header.getFiled(), header.getFiledClazz(), header.getWriteConverter()), null);
            }
        }
        return templates;
    }

    public void exportObject2Excel(String templatePath, int sheetIndex, Map<String, List<?>> data, Map<String, String> extendMap, Class clazz, boolean isWriteHeader, String targetPath) throws Exception {
        this.exportExcelByModuleHandler(templatePath, sheetIndex, data, extendMap, clazz, isWriteHeader).write2File(targetPath);
    }

    public void exportObject2Excel(String templatePath, int sheetIndex, Map<String, List<?>> data, Map<String, String> extendMap, Class clazz, boolean isWriteHeader, OutputStream os) throws Exception {
        this.exportExcelByModuleHandler(templatePath, sheetIndex, data, extendMap, clazz, isWriteHeader).write2Stream(os);
    }

    public void exportObject2Excel(String templatePath, Map<String, List<?>> data, Map<String, String> extendMap, Class clazz, String targetPath) throws Exception {
        this.exportExcelByModuleHandler(templatePath, 0, data, extendMap, clazz, false).write2File(targetPath);
    }

    public void exportObject2Excel(String templatePath, Map<String, List<?>> data, Map<String, String> extendMap, Class clazz, OutputStream os) throws Exception {
        this.exportExcelByModuleHandler(templatePath, 0, data, extendMap, clazz, false).write2Stream(os);
    }

    private ExcelTemplate exportExcelByModuleHandler(String templatePath, int sheetIndex, Map<String, List<?>> data, Map<String, String> extendMap, Class clazz, boolean isWriteHeader) throws Exception {
        ExcelTemplate templates = ExcelTemplate.getInstance(templatePath, sheetIndex);
        templates.extendData(extendMap);
        List<ExcelHeader> headers = Utils.getHeaderList(clazz);
        if (isWriteHeader) {
            templates.createNewRow();
            for (ExcelHeader excelHeader : headers) {
                templates.createCell(excelHeader.getTitle(), null);
            }
        }
        for (Map.Entry entry : data.entrySet()) {
            for (Object object : (List)entry.getValue()) {
                templates.createNewRow();
                templates.insertSerial((String)entry.getKey());
                for (ExcelHeader header : headers) {
                    templates.createCell(Utils.getProperty(object, header.getFiled(), header.getFiledClazz(), header.getWriteConverter()), (String)entry.getKey());
                }
            }
        }
        return templates;
    }

    public void exportObjects2Excel(List<?> data, Class clazz, boolean isWriteHeader, String sheetName, boolean isXSSF, String targetPath) throws Exception {
        FileOutputStream fos = new FileOutputStream(targetPath);
        this.exportExcelNoModuleHandler(data, clazz, isWriteHeader, sheetName, isXSSF).write((OutputStream)fos);
    }

    public void exportObjects2Excel(List<?> data, Class clazz, boolean isWriteHeader, String sheetName, boolean isXSSF, OutputStream os) throws Exception {
        this.exportExcelNoModuleHandler(data, clazz, isWriteHeader, sheetName, isXSSF).write(os);
    }

    public void exportObjects2Excel(List<?> data, Class clazz, boolean isWriteHeader, String targetPath) throws Exception {
        FileOutputStream fos = new FileOutputStream(targetPath);
        this.exportExcelNoModuleHandler(data, clazz, isWriteHeader, null, true).write((OutputStream)fos);
    }

    public void exportObjects2Excel(List<?> data, Class clazz, boolean isWriteHeader, OutputStream os) throws Exception {
        this.exportExcelNoModuleHandler(data, clazz, isWriteHeader, null, true).write(os);
    }

    private Workbook exportExcelNoModuleHandler(List<?> data, Class clazz, boolean isWriteHeader, String sheetName, boolean isXSSF) throws Exception {
        Object workbook = isXSSF ? new XSSFWorkbook() : new HSSFWorkbook();
        Sheet sheet = null != sheetName && !"".equals(sheetName) ? workbook.createSheet(sheetName) : workbook.createSheet();
        Row row = sheet.createRow(0);
        List<ExcelHeader> headers = Utils.getHeaderList(clazz);
        if (isWriteHeader) {
            for (int i = 0; i < headers.size(); ++i) {
                row.createCell(i).setCellValue(headers.get(i).getTitle());
            }
        }
        for (int i = 0; i < data.size(); ++i) {
            row = sheet.createRow(i + 1);
            Object _data = data.get(i);
            for (int j = 0; j < headers.size(); ++j) {
                row.createCell(j).setCellValue(Utils.getProperty(_data, headers.get(j).getFiled(), headers.get(j).getFiledClazz(), headers.get(j).getWriteConverter()));
            }
        }
        return workbook;
    }

    public void exportObjects2Excel(List<?> data, List<String> header, String sheetName, boolean isXSSF, String targetPath) throws Exception {
        this.exportExcelNoModuleHandler(data, header, sheetName, isXSSF).write((OutputStream)new FileOutputStream(targetPath));
    }

    public void exportObjects2Excel(List<?> data, List<String> header, String sheetName, boolean isXSSF, OutputStream os) throws Exception {
        this.exportExcelNoModuleHandler(data, header, sheetName, isXSSF).write(os);
    }

    public void exportObjects2Excel(List<?> data, List<String> header, String targetPath) throws Exception {
        this.exportExcelNoModuleHandler(data, header, null, true).write((OutputStream)new FileOutputStream(targetPath));
    }

    public void exportObjects2Excel(List<?> data, List<String> header, OutputStream os) throws Exception {
        this.exportExcelNoModuleHandler(data, header, null, true).write(os);
    }

    public void exportObjects2Excel(List<?> data, String targetPath) throws Exception {
        this.exportExcelNoModuleHandler(data, null, null, true).write((OutputStream)new FileOutputStream(targetPath));
    }

    public void exportObjects2Excel(List<?> data, OutputStream os) throws Exception {
        this.exportExcelNoModuleHandler(data, null, null, true).write(os);
    }

    private Workbook exportExcelNoModuleHandler(List<?> data, List<String> header, String sheetName, boolean isXSSF) throws Exception {
        Object workbook = isXSSF ? new XSSFWorkbook() : new HSSFWorkbook();
        Sheet sheet = null != sheetName && !"".equals(sheetName) ? workbook.createSheet(sheetName) : workbook.createSheet();
        int rowIndex = 0;
        if (null != header && header.size() > 0) {
            Row row = sheet.createRow(rowIndex);
            for (int i = 0; i < header.size(); ++i) {
                row.createCell(i, 1).setCellValue(header.get(i));
            }
            ++rowIndex;
        }
        for (Object object : data) {
            Row row = sheet.createRow(rowIndex);
            if (object.getClass().isArray()) {
                for (int j = 0; j < Array.getLength(object); ++j) {
                    row.createCell(j, 1).setCellValue(Array.get(object, j).toString());
                }
            } else if (object instanceof Collection) {
                Collection items = (Collection)object;
                int j = 0;
                for (Object item : items) {
                    row.createCell(j, 1).setCellValue(item.toString());
                    ++j;
                }
            } else {
                row.createCell(0, 1).setCellValue(object.toString());
            }
            ++rowIndex;
        }
        return workbook;
    }
}

