/*
 * Decompiled with CFR 0.152.
 */
package com.github.crab2died.utils;

import com.github.crab2died.annotation.ExcelField;
import com.github.crab2died.converter.DefaultConvertible;
import com.github.crab2died.converter.WriteConvertible;
import com.github.crab2died.handler.ExcelHeader;
import com.github.crab2died.utils.DateUtils;
import com.github.crab2died.utils.RegularUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public class Utils {
    public static List<ExcelHeader> getHeaderList(Class<?> clz) throws IllegalAccessException, InstantiationException {
        ArrayList<ExcelHeader> headers = new ArrayList<ExcelHeader>();
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> clazz = clz; clazz != Object.class; clazz = clazz.getSuperclass()) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        for (Field field : fields) {
            if (!field.isAnnotationPresent(ExcelField.class)) continue;
            ExcelField er = field.getAnnotation(ExcelField.class);
            headers.add(new ExcelHeader(er.title(), er.order(), er.writeConverter().newInstance(), er.readConverter().newInstance(), field.getName(), field.getType()));
        }
        Collections.sort(headers);
        return headers;
    }

    public static Map<Integer, ExcelHeader> getHeaderMap(Row titleRow, Class<?> clz) throws InstantiationException, IllegalAccessException {
        List<ExcelHeader> headers = Utils.getHeaderList(clz);
        HashMap<Integer, ExcelHeader> maps = new HashMap<Integer, ExcelHeader>();
        block0: for (Cell c : titleRow) {
            String title = c.getStringCellValue();
            for (ExcelHeader eh : headers) {
                if (!eh.getTitle().equals(title.trim())) continue;
                maps.put(c.getColumnIndex(), eh);
                continue block0;
            }
        }
        return maps;
    }

    public static String getCellValue(Cell c) {
        String o;
        switch (c.getCellType()) {
            case 3: {
                o = "";
                break;
            }
            case 4: {
                o = String.valueOf(c.getBooleanCellValue());
                break;
            }
            case 2: {
                o = String.valueOf(c.getCellFormula());
                break;
            }
            case 0: {
                o = String.valueOf(c.getNumericCellValue());
                o = Utils.matchDoneBigDecimal(o);
                o = RegularUtils.converNumByReg(o);
                break;
            }
            case 1: {
                o = c.getStringCellValue();
                break;
            }
            default: {
                o = null;
            }
        }
        return o;
    }

    public static Object str2TargetClass(String strField, Class<?> clazz) {
        if (null == strField || "".equals(strField)) {
            return null;
        }
        if (Long.class == clazz || Long.TYPE == clazz) {
            strField = Utils.matchDoneBigDecimal(strField);
            strField = RegularUtils.converNumByReg(strField);
            return Long.parseLong(strField);
        }
        if (Integer.class == clazz || Integer.TYPE == clazz) {
            strField = Utils.matchDoneBigDecimal(strField);
            strField = RegularUtils.converNumByReg(strField);
            return Integer.parseInt(strField);
        }
        if (Float.class == clazz || Float.TYPE == clazz) {
            strField = Utils.matchDoneBigDecimal(strField);
            return Float.valueOf(Float.parseFloat(strField));
        }
        if (Double.class == clazz || Double.TYPE == clazz) {
            strField = Utils.matchDoneBigDecimal(strField);
            return Double.parseDouble(strField);
        }
        if (Character.class == clazz || Character.TYPE == clazz) {
            return Character.valueOf(strField.toCharArray()[0]);
        }
        if (Boolean.class == clazz || Boolean.TYPE == clazz) {
            return Boolean.parseBoolean(strField);
        }
        if (Date.class == clazz) {
            return DateUtils.str2DateUnmatch2Null(strField);
        }
        return strField;
    }

    private static String matchDoneBigDecimal(String bigDecimal) {
        boolean flg = Pattern.matches("^-?\\d+(\\.\\d+)?(E-?\\d+)?$", bigDecimal);
        if (flg) {
            BigDecimal bd = new BigDecimal(bigDecimal);
            bigDecimal = bd.toPlainString();
        }
        return bigDecimal;
    }

    private static String getOrSet(Class fieldClass, String fieldName, MethodType methodType) {
        if (null == fieldClass || null == fieldName) {
            return null;
        }
        if (Boolean.TYPE == fieldClass) {
            if (MethodType.SET == methodType && fieldName.startsWith("is") && Character.isUpperCase(fieldName.substring(2, 3).toCharArray()[0])) {
                return methodType.getValue() + fieldName.substring(2);
            }
            if (MethodType.GET == methodType) {
                if (fieldName.startsWith("is") && Character.isUpperCase(fieldName.substring(2, 3).toCharArray()[0])) {
                    return fieldName;
                }
                return "is" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            }
        }
        if (Boolean.class == fieldClass) {
            if (MethodType.SET == methodType && fieldName.startsWith("is") && Character.isUpperCase(fieldName.substring(2, 3).toCharArray()[0])) {
                return methodType.getValue() + fieldName.substring(2);
            }
            if (MethodType.GET == methodType && fieldName.startsWith("is") && Character.isUpperCase(fieldName.substring(2, 3).toCharArray()[0])) {
                return methodType.getValue() + fieldName.substring(2);
            }
        }
        return methodType.getValue() + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    private static Field matchClassField(Class clazz, String fieldName) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != Object.class) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        for (Field field : fields) {
            if (!fieldName.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public static String getProperty(Object bean, String fieldName, Class fieldClass, WriteConvertible writeConvertible) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = bean.getClass().getDeclaredMethod(Utils.getOrSet(fieldClass, fieldName, MethodType.GET), new Class[0]);
        Object object = method.invoke(bean, new Object[0]);
        if (null != writeConvertible && writeConvertible.getClass() != DefaultConvertible.class) {
            object = writeConvertible.execWrite(object);
        }
        return object.toString();
    }

    public static void copyProperty(Object bean, String name, Object value) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Field field = Utils.matchClassField(bean.getClass(), name);
        if (null == field) {
            return;
        }
        Method method = bean.getClass().getDeclaredMethod(Utils.getOrSet(field.getType(), name, MethodType.SET), field.getType());
        if (value.getClass() == field.getType()) {
            method.invoke(bean, value);
        } else {
            method.invoke(bean, Utils.str2TargetClass(value.toString(), field.getType()));
        }
    }

    private static enum MethodType {
        GET("get"),
        SET("set");

        private String value;

        private MethodType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

