/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.support.scan;

import com.github.houbb.chars.scan.api.CharsScanContext;
import com.github.houbb.chars.scan.constant.CharsScanTypeEnum;
import com.github.houbb.chars.scan.support.scan.AbstractConditionCharScan;
import com.github.houbb.chars.scan.util.InnerCharUtil;
import com.github.houbb.heaven.util.lang.CharUtil;

public class BirthdayConditionCharScan
extends AbstractConditionCharScan {
    @Override
    protected boolean isCharMatchCondition(int i, char c, char[] chars) {
        return CharUtil.isNumber((char)c);
    }

    @Override
    protected boolean isStringMatchCondition(int i, char c, char[] chars, CharsScanContext context) {
        StringBuilder buffer = super.getBuffer();
        int bufferLen = buffer.length();
        if (bufferLen != 8) {
            return false;
        }
        return InnerCharUtil.isValidDate(buffer, 0);
    }

    @Override
    public String getScanType() {
        return CharsScanTypeEnum.BIRTHDAY.getScanType();
    }

    @Override
    public int getPriority() {
        return CharsScanTypeEnum.BIRTHDAY.getPriority();
    }
}

