/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.net;

import com.github.houbb.heaven.response.exception.CommonRuntimeException;
import com.github.houbb.heaven.util.common.ArgUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public final class URLUtil {
    private URLUtil() {
    }

    public static List<String> readAllLines(URL url) {
        return URLUtil.readAllLines(url, "UTF-8");
    }

    public static List<String> readAllLines(URL url, String charset) {
        ArgUtil.notNull(url, "url");
        ArgUtil.notEmpty(charset, "charset");
        ArrayList<String> resultList = new ArrayList<String>();
        try (InputStream is = url.openStream();
             BufferedReader br = new BufferedReader(new InputStreamReader(is, Charset.forName(charset)));){
            String line;
            while ((line = br.readLine()) != null) {
                resultList.add(line);
            }
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
        return resultList;
    }
}

