/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.support.attr.impl;

import com.github.houbb.heaven.support.attr.IAttributeContext;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.util.Optional;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AttributeContext
implements IAttributeContext {
    private Map<String, Object> context;

    public AttributeContext() {
        this.context = new ConcurrentHashMap<String, Object>();
    }

    public AttributeContext(Map<String, Object> map) {
        this.context = new ConcurrentHashMap<String, Object>(map);
    }

    protected AttributeContext putAttrMap(Map<String, ?> map) {
        ArgUtil.notNull(map, "map");
        this.context.putAll(map);
        return this;
    }

    protected Set<Map.Entry<String, Object>> entrySet() {
        return this.context.entrySet();
    }

    @Override
    public AttributeContext putAttr(String key, Object value) {
        this.context.put(key, value);
        return this;
    }

    @Override
    public Object getAttr(String key) {
        return this.context.get(key);
    }

    @Override
    public Optional<Object> getAttrOptional(String key) {
        Object object = this.getAttr(key);
        return Optional.ofNullable(object);
    }

    @Override
    public String getAttrString(String key) {
        Object object = this.getAttr(key);
        return ObjectUtil.objectToString(object);
    }

    @Override
    public Boolean getAttrBoolean(String key) {
        Optional<Object> objectOptional = this.getAttrOptional(key);
        return objectOptional.getCastOrNull(Boolean.class);
    }

    @Override
    public Character getAttrCharacter(String key) {
        Optional<Object> objectOptional = this.getAttrOptional(key);
        return objectOptional.getCastOrNull(Character.class);
    }

    @Override
    public Byte getAttrByte(String key) {
        Optional<Object> objectOptional = this.getAttrOptional(key);
        return objectOptional.getCastOrNull(Byte.class);
    }

    @Override
    public Short getAttrShort(String key) {
        Optional<Object> objectOptional = this.getAttrOptional(key);
        return objectOptional.getCastOrNull(Short.class);
    }

    @Override
    public Integer getAttrInteger(String key) {
        Optional<Object> objectOptional = this.getAttrOptional(key);
        return objectOptional.getCastOrNull(Integer.class);
    }

    @Override
    public Float getAttrFloat(String key) {
        Optional<Object> objectOptional = this.getAttrOptional(key);
        return objectOptional.getCastOrNull(Float.class);
    }

    @Override
    public Double getAttrDouble(String key) {
        Optional<Object> objectOptional = this.getAttrOptional(key);
        return objectOptional.getCastOrNull(Double.class);
    }

    @Override
    public Long getAttrLong(String key) {
        Optional<Object> objectOptional = this.getAttrOptional(key);
        return objectOptional.getCastOrNull(Long.class);
    }

    @Override
    public IAttributeContext removeAttr(String key) {
        this.context.remove(key);
        return this;
    }

    @Override
    public boolean containsKey(String key) {
        return this.context.containsKey(key);
    }

    @Override
    public Set<String> keySet() {
        return this.context.keySet();
    }
}

