/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.support.concurrent.context;

import com.github.houbb.heaven.support.concurrent.context.CrossThreadProcessor;
import com.github.houbb.heaven.util.lang.SpiUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class CrossThreadWrapper<T>
implements Runnable,
Callable<T> {
    private Runnable runnable;
    private Callable<T> callable;
    private static List<CrossThreadProcessor> processorList = new ArrayList<CrossThreadProcessor>();
    private final Map<String, Object> context = new HashMap<String, Object>();

    public CrossThreadWrapper(Runnable runnable) {
        this.initContext();
        this.runnable = runnable;
    }

    public CrossThreadWrapper(Callable<T> callable) {
        this.initContext();
        this.callable = callable;
    }

    @Override
    public void run() {
        try {
            this.beforeExecute();
            this.runnable.run();
        }
        finally {
            this.afterExecute();
        }
    }

    @Override
    public T call() throws Exception {
        try {
            this.beforeExecute();
            T t = this.callable.call();
            return t;
        }
        finally {
            this.afterExecute();
        }
    }

    protected void initContext() {
        for (CrossThreadProcessor processor : processorList) {
            processor.initContext(this.context);
        }
    }

    protected void beforeExecute() {
        for (CrossThreadProcessor processor : processorList) {
            processor.beforeExecute(this.context);
        }
    }

    protected void afterExecute() {
        for (CrossThreadProcessor processor : processorList) {
            processor.afterExecute(this.context);
        }
    }

    static {
        processorList = SpiUtil.getClassImplList(CrossThreadProcessor.class);
    }
}

