/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.property.support.converter.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.lang.NumUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.property.support.converter.IFieldValueContext;
import com.github.houbb.property.support.converter.IPropertyValueContext;
import com.github.houbb.property.support.converter.impl.AbstractValueConverter;

@ThreadSafe
public abstract class AbstractNumberValueConverter<T extends Number>
extends AbstractValueConverter<T> {
    protected abstract T getNumberFieldValue(String var1, IFieldValueContext var2);

    @Override
    protected T getFieldValue(String value, IFieldValueContext context) {
        String format = context.format();
        if (StringUtil.isNotEmpty((String)format)) {
            return (T)((Number)NumUtil.getFormatNum((String)value, (String)format, context.field().getType()));
        }
        return this.getNumberFieldValue(value, context);
    }

    @Override
    protected String getPropertyValue(T value, IPropertyValueContext context) {
        String format = context.format();
        if (StringUtil.isNotEmpty((String)format)) {
            return NumUtil.getNumFormat(value, (String)format);
        }
        return value.toString();
    }
}

