/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker;

import com.github.ltsopensource.biz.logger.JobLogger;
import com.github.ltsopensource.biz.logger.SmartJobLogger;
import com.github.ltsopensource.cmd.HttpCmdProc;
import com.github.ltsopensource.core.cluster.AbstractServerNode;
import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.monitor.MStatReporter;
import com.github.ltsopensource.core.spi.ServiceLoader;
import com.github.ltsopensource.jobtracker.channel.ChannelManager;
import com.github.ltsopensource.jobtracker.cmd.AddJobHttpCmd;
import com.github.ltsopensource.jobtracker.cmd.LoadJobHttpCmd;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;
import com.github.ltsopensource.jobtracker.domain.JobTrackerNode;
import com.github.ltsopensource.jobtracker.monitor.JobTrackerMStatReporter;
import com.github.ltsopensource.jobtracker.processor.RemotingDispatcher;
import com.github.ltsopensource.jobtracker.sender.JobSender;
import com.github.ltsopensource.jobtracker.support.JobReceiver;
import com.github.ltsopensource.jobtracker.support.NonRelyOnPrevCycleJobScheduler;
import com.github.ltsopensource.jobtracker.support.OldDataHandler;
import com.github.ltsopensource.jobtracker.support.checker.ExecutableDeadJobChecker;
import com.github.ltsopensource.jobtracker.support.checker.ExecutingDeadJobChecker;
import com.github.ltsopensource.jobtracker.support.checker.FeedbackJobSendChecker;
import com.github.ltsopensource.jobtracker.support.cluster.JobClientManager;
import com.github.ltsopensource.jobtracker.support.cluster.TaskTrackerManager;
import com.github.ltsopensource.jobtracker.support.listener.JobNodeChangeListener;
import com.github.ltsopensource.jobtracker.support.listener.JobTrackerMasterChangeListener;
import com.github.ltsopensource.jobtracker.support.policy.OldDataDeletePolicy;
import com.github.ltsopensource.queue.JobQueueFactory;
import com.github.ltsopensource.remoting.RemotingProcessor;

public class JobTracker
extends AbstractServerNode<JobTrackerNode, JobTrackerAppContext> {
    public JobTracker() {
        this.addNodeChangeListener(new JobNodeChangeListener((JobTrackerAppContext)this.appContext));
        this.addMasterChangeListener(new JobTrackerMasterChangeListener((JobTrackerAppContext)this.appContext));
    }

    protected void beforeStart() {
        ((JobTrackerAppContext)this.appContext).setMStatReporter((MStatReporter)new JobTrackerMStatReporter((JobTrackerAppContext)this.appContext));
        ((JobTrackerAppContext)this.appContext).setChannelManager(new ChannelManager());
        ((JobTrackerAppContext)this.appContext).setJobClientManager(new JobClientManager((JobTrackerAppContext)this.appContext));
        ((JobTrackerAppContext)this.appContext).setTaskTrackerManager(new TaskTrackerManager((JobTrackerAppContext)this.appContext));
        ((JobTrackerAppContext)this.appContext).setRemotingServer(this.remotingServer);
        ((JobTrackerAppContext)this.appContext).setJobLogger((JobLogger)new SmartJobLogger(this.appContext));
        JobQueueFactory factory = (JobQueueFactory)ServiceLoader.load(JobQueueFactory.class, (Config)this.config);
        ((JobTrackerAppContext)this.appContext).setExecutableJobQueue(factory.getExecutableJobQueue(this.config));
        ((JobTrackerAppContext)this.appContext).setExecutingJobQueue(factory.getExecutingJobQueue(this.config));
        ((JobTrackerAppContext)this.appContext).setCronJobQueue(factory.getCronJobQueue(this.config));
        ((JobTrackerAppContext)this.appContext).setRepeatJobQueue(factory.getRepeatJobQueue(this.config));
        ((JobTrackerAppContext)this.appContext).setSuspendJobQueue(factory.getSuspendJobQueue(this.config));
        ((JobTrackerAppContext)this.appContext).setJobFeedbackQueue(factory.getJobFeedbackQueue(this.config));
        ((JobTrackerAppContext)this.appContext).setNodeGroupStore(factory.getNodeGroupStore(this.config));
        ((JobTrackerAppContext)this.appContext).setPreLoader(factory.getPreLoader(this.appContext));
        ((JobTrackerAppContext)this.appContext).setJobReceiver(new JobReceiver((JobTrackerAppContext)this.appContext));
        ((JobTrackerAppContext)this.appContext).setJobSender(new JobSender((JobTrackerAppContext)this.appContext));
        ((JobTrackerAppContext)this.appContext).setNonRelyOnPrevCycleJobScheduler(new NonRelyOnPrevCycleJobScheduler((JobTrackerAppContext)this.appContext));
        ((JobTrackerAppContext)this.appContext).setExecutableDeadJobChecker(new ExecutableDeadJobChecker((JobTrackerAppContext)this.appContext));
        ((JobTrackerAppContext)this.appContext).setExecutingDeadJobChecker(new ExecutingDeadJobChecker((JobTrackerAppContext)this.appContext));
        ((JobTrackerAppContext)this.appContext).setFeedbackJobSendChecker(new FeedbackJobSendChecker((JobTrackerAppContext)this.appContext));
        ((JobTrackerAppContext)this.appContext).getHttpCmdServer().registerCommands(new HttpCmdProc[]{new LoadJobHttpCmd((JobTrackerAppContext)this.appContext), new AddJobHttpCmd((JobTrackerAppContext)this.appContext)});
        if (((JobTrackerAppContext)this.appContext).getOldDataHandler() == null) {
            ((JobTrackerAppContext)this.appContext).setOldDataHandler(new OldDataDeletePolicy());
        }
    }

    protected void afterStart() {
        ((JobTrackerAppContext)this.appContext).getChannelManager().start();
        ((JobTrackerAppContext)this.appContext).getMStatReporter().start();
    }

    protected void afterStop() {
        ((JobTrackerAppContext)this.appContext).getChannelManager().stop();
        ((JobTrackerAppContext)this.appContext).getMStatReporter().stop();
        ((JobTrackerAppContext)this.appContext).getHttpCmdServer().stop();
    }

    protected void beforeStop() {
    }

    protected RemotingProcessor getDefaultProcessor() {
        return new RemotingDispatcher((JobTrackerAppContext)this.appContext);
    }

    public void setOldDataHandler(OldDataHandler oldDataHandler) {
        ((JobTrackerAppContext)this.appContext).setOldDataHandler(oldDataHandler);
    }
}

