/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.channel;

import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.factory.NamedThreadFactory;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.jobtracker.channel.ChannelWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ChannelManager {
    private final Logger LOGGER = LoggerFactory.getLogger(ChannelManager.class);
    private final ConcurrentHashMap<String, List<ChannelWrapper>> clientChannelMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, List<ChannelWrapper>> taskTrackerChannelMap = new ConcurrentHashMap();
    private final ScheduledExecutorService channelCheckExecutorService = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("LTS-Channel-Checker", true));
    private ScheduledFuture<?> scheduledFuture;
    private final ConcurrentHashMap<String, Long> offlineTaskTrackerMap = new ConcurrentHashMap();
    private final ScheduledExecutorService offlineTaskTrackerCheckExecutorService = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("LTS-offline-TaskTracker-Checker", true));
    private ScheduledFuture<?> offlineTaskTrackerScheduledFuture;
    private AtomicBoolean start = new AtomicBoolean(false);

    public void start() {
        try {
            if (this.start.compareAndSet(false, true)) {
                this.scheduledFuture = this.channelCheckExecutorService.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ChannelManager.this.checkCloseChannel(NodeType.JOB_CLIENT, ChannelManager.this.clientChannelMap);
                            if (ChannelManager.this.LOGGER.isDebugEnabled()) {
                                ChannelManager.this.LOGGER.debug("JobClient Channel Pool " + ChannelManager.this.clientChannelMap);
                            }
                            ChannelManager.this.checkCloseChannel(NodeType.TASK_TRACKER, ChannelManager.this.taskTrackerChannelMap);
                            if (ChannelManager.this.LOGGER.isDebugEnabled()) {
                                ChannelManager.this.LOGGER.debug("TaskTracker Channel Pool " + ChannelManager.this.taskTrackerChannelMap);
                            }
                        }
                        catch (Throwable t) {
                            ChannelManager.this.LOGGER.error("Check channel error!", t);
                        }
                    }
                }, 10L, 10L, TimeUnit.SECONDS);
                this.offlineTaskTrackerScheduledFuture = this.offlineTaskTrackerCheckExecutorService.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (ChannelManager.this.offlineTaskTrackerMap.size() > 0) {
                                for (Map.Entry entry : ChannelManager.this.offlineTaskTrackerMap.entrySet()) {
                                    if (SystemClock.now() - (Long)entry.getValue() <= 20000L) continue;
                                    ChannelManager.this.offlineTaskTrackerMap.remove(entry.getKey());
                                }
                            }
                        }
                        catch (Throwable t) {
                            ChannelManager.this.LOGGER.error("Check offline channel error!", t);
                        }
                    }
                }, 1L, 1L, TimeUnit.MINUTES);
            }
            this.LOGGER.info("Start channel manager success!");
        }
        catch (Throwable t) {
            this.LOGGER.error("Start channel manager failed!", t);
        }
    }

    public void stop() {
        try {
            if (this.start.compareAndSet(true, false)) {
                this.scheduledFuture.cancel(true);
                this.channelCheckExecutorService.shutdown();
                this.offlineTaskTrackerScheduledFuture.cancel(true);
                this.offlineTaskTrackerCheckExecutorService.shutdown();
            }
            this.LOGGER.info("Stop channel manager success!");
        }
        catch (Throwable t) {
            this.LOGGER.error("Stop channel manager failed!", t);
        }
    }

    private void checkCloseChannel(NodeType nodeType, ConcurrentHashMap<String, List<ChannelWrapper>> channelMap) {
        for (Map.Entry<String, List<ChannelWrapper>> entry : channelMap.entrySet()) {
            List<ChannelWrapper> channels = entry.getValue();
            ArrayList<ChannelWrapper> removeList = new ArrayList<ChannelWrapper>();
            for (ChannelWrapper channel : channels) {
                if (!channel.isClosed()) continue;
                removeList.add(channel);
                this.LOGGER.info("close channel={}", new Object[]{channel});
            }
            channels.removeAll(removeList);
            if (nodeType != NodeType.TASK_TRACKER) continue;
            for (ChannelWrapper channelWrapper : removeList) {
                this.offlineTaskTrackerMap.put(channelWrapper.getIdentity(), SystemClock.now());
            }
        }
    }

    public List<ChannelWrapper> getChannels(String nodeGroup, NodeType nodeType) {
        if (nodeType == NodeType.JOB_CLIENT) {
            return this.clientChannelMap.get(nodeGroup);
        }
        if (nodeType == NodeType.TASK_TRACKER) {
            return this.taskTrackerChannelMap.get(nodeGroup);
        }
        return null;
    }

    public ChannelWrapper getChannel(String nodeGroup, NodeType nodeType, String identity) {
        List<ChannelWrapper> channelWrappers = this.getChannels(nodeGroup, nodeType);
        if (channelWrappers != null && channelWrappers.size() != 0) {
            for (ChannelWrapper channelWrapper : channelWrappers) {
                if (!channelWrapper.getIdentity().equals(identity)) continue;
                return channelWrapper;
            }
        }
        return null;
    }

    public void offerChannel(ChannelWrapper channel) {
        NodeType nodeType;
        String nodeGroup = channel.getNodeGroup();
        List<ChannelWrapper> channels = this.getChannels(nodeGroup, nodeType = channel.getNodeType());
        if (channels == null) {
            channels = new ArrayList<ChannelWrapper>();
            if (nodeType == NodeType.JOB_CLIENT) {
                this.clientChannelMap.put(nodeGroup, channels);
            } else if (nodeType == NodeType.TASK_TRACKER) {
                this.taskTrackerChannelMap.put(nodeGroup, channels);
                if (this.offlineTaskTrackerMap.containsKey(channel.getIdentity())) {
                    this.offlineTaskTrackerMap.remove(channel.getIdentity());
                }
            }
            channels.add(channel);
            this.LOGGER.info("new connected channel={}", new Object[]{channel});
        } else if (!channels.contains(channel)) {
            channels.add(channel);
            this.LOGGER.info("new connected channel={}", new Object[]{channel});
        }
    }

    public Long getOfflineTimestamp(String identity) {
        return this.offlineTaskTrackerMap.get(identity);
    }

    public void removeChannel(ChannelWrapper channel) {
        NodeType nodeType;
        String nodeGroup = channel.getNodeGroup();
        List<ChannelWrapper> channels = this.getChannels(nodeGroup, nodeType = channel.getNodeType());
        if (channels != null) {
            channels.remove(channel);
            this.LOGGER.info("remove channel={}", new Object[]{channel});
        }
    }
}

