/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.complete;

import com.github.ltsopensource.biz.logger.domain.JobLogPo;
import com.github.ltsopensource.biz.logger.domain.LogType;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.constant.Level;
import com.github.ltsopensource.core.domain.JobMeta;
import com.github.ltsopensource.core.domain.JobRunResult;
import com.github.ltsopensource.core.json.JSON;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.support.CronExpressionUtils;
import com.github.ltsopensource.core.support.JobDomainConverter;
import com.github.ltsopensource.core.support.JobUtils;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;
import com.github.ltsopensource.queue.domain.JobPo;
import com.github.ltsopensource.store.jdbc.exception.DupEntryException;
import java.util.Date;
import java.util.List;

public class JobFinishHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobFinishHandler.class);
    private JobTrackerAppContext appContext;

    public JobFinishHandler(JobTrackerAppContext appContext) {
        this.appContext = appContext;
    }

    public void onComplete(List<JobRunResult> results) {
        if (CollectionUtils.isEmpty(results)) {
            return;
        }
        for (JobRunResult result : results) {
            JobMeta jobMeta = result.getJobMeta();
            boolean isRetryForThisTime = Boolean.TRUE.toString().equals(jobMeta.getInternalExtParam("__LTS_Is_Retry_Job"));
            boolean isOnce = Boolean.TRUE.toString().equals(jobMeta.getInternalExtParam("__LTS_ONCE"));
            if (!isOnce && jobMeta.getJob().isCron()) {
                this.finishCronJob(jobMeta.getJobId());
            } else if (!isOnce && jobMeta.getJob().isRepeatable()) {
                this.finishRepeatJob(jobMeta.getJobId(), isRetryForThisTime);
            }
            this.appContext.getExecutingJobQueue().remove(jobMeta.getJobId());
        }
    }

    private void finishCronJob(String jobId) {
        JobPo jobPo = this.appContext.getCronJobQueue().getJob(jobId);
        if (jobPo == null) {
            return;
        }
        Date nextTriggerTime = CronExpressionUtils.getNextTriggerTime((String)jobPo.getCronExpression());
        if (nextTriggerTime == null) {
            this.appContext.getCronJobQueue().remove(jobId);
            return;
        }
        try {
            jobPo.setTaskTrackerIdentity(null);
            jobPo.setIsRunning(Boolean.valueOf(false));
            jobPo.setTriggerTime(Long.valueOf(nextTriggerTime.getTime()));
            jobPo.setGmtModified(Long.valueOf(SystemClock.now()));
            this.appContext.getExecutableJobQueue().add(jobPo);
        }
        catch (DupEntryException e) {
            LOGGER.warn("ExecutableJobQueue already exist:" + JSON.toJSONString((Object)jobPo));
        }
    }

    private void finishRepeatJob(String jobId, boolean isRetryForThisTime) {
        JobPo jobPo = this.appContext.getRepeatJobQueue().getJob(jobId);
        if (jobPo == null) {
            return;
        }
        if (jobPo.getRepeatCount() != -1 && jobPo.getRepeatedCount() >= jobPo.getRepeatCount()) {
            this.appContext.getRepeatJobQueue().remove(jobId);
            this.repeatJobRemoveLog(jobPo);
            return;
        }
        int repeatedCount = jobPo.getRepeatedCount();
        if (!isRetryForThisTime) {
            repeatedCount = this.appContext.getRepeatJobQueue().incRepeatedCount(jobId);
        }
        if (repeatedCount == -1) {
            return;
        }
        long nexTriggerTime = JobUtils.getRepeatNextTriggerTime((JobPo)jobPo);
        try {
            jobPo.setRepeatedCount(Integer.valueOf(repeatedCount));
            jobPo.setTaskTrackerIdentity(null);
            jobPo.setIsRunning(Boolean.valueOf(false));
            jobPo.setTriggerTime(Long.valueOf(nexTriggerTime));
            jobPo.setGmtModified(Long.valueOf(SystemClock.now()));
            this.appContext.getExecutableJobQueue().add(jobPo);
        }
        catch (DupEntryException e) {
            LOGGER.warn("ExecutableJobQueue already exist:" + JSON.toJSONString((Object)jobPo));
        }
    }

    private void repeatJobRemoveLog(JobPo jobPo) {
        JobLogPo jobLogPo = JobDomainConverter.convertJobLog((JobPo)jobPo);
        jobLogPo.setSuccess(true);
        jobLogPo.setLogType(LogType.DEL);
        jobLogPo.setLogTime(Long.valueOf(SystemClock.now()));
        jobLogPo.setLevel(Level.INFO);
        jobLogPo.setMsg("Repeat Job Finished");
        this.appContext.getJobLogger().log(jobLogPo);
    }
}

