/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.processor;

import com.github.ltsopensource.biz.logger.domain.JobLogPo;
import com.github.ltsopensource.biz.logger.domain.LogType;
import com.github.ltsopensource.core.constant.Level;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.protocol.JobProtos;
import com.github.ltsopensource.core.protocol.command.JobCancelRequest;
import com.github.ltsopensource.core.support.JobDomainConverter;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;
import com.github.ltsopensource.jobtracker.processor.AbstractRemotingProcessor;
import com.github.ltsopensource.queue.domain.JobPo;
import com.github.ltsopensource.remoting.Channel;
import com.github.ltsopensource.remoting.exception.RemotingCommandException;
import com.github.ltsopensource.remoting.protocol.RemotingCommand;

public class JobCancelProcessor
extends AbstractRemotingProcessor {
    private final Logger LOGGER = LoggerFactory.getLogger(JobCancelProcessor.class);

    public JobCancelProcessor(JobTrackerAppContext appContext) {
        super(appContext);
    }

    public RemotingCommand processRequest(Channel channel, RemotingCommand request) throws RemotingCommandException {
        JobCancelRequest jobCancelRequest = (JobCancelRequest)request.getBody();
        String taskId = jobCancelRequest.getTaskId();
        String taskTrackerNodeGroup = jobCancelRequest.getTaskTrackerNodeGroup();
        JobPo jobPo = this.appContext.getCronJobQueue().getJob(taskTrackerNodeGroup, taskId);
        if (jobPo == null) {
            jobPo = this.appContext.getRepeatJobQueue().getJob(taskTrackerNodeGroup, taskId);
        }
        if (jobPo == null) {
            jobPo = this.appContext.getExecutableJobQueue().getJob(taskTrackerNodeGroup, taskId);
        }
        if (jobPo != null) {
            this.appContext.getExecutableJobQueue().removeBatch(jobPo.getRealTaskId(), jobPo.getTaskTrackerNodeGroup());
            if (jobPo.isCron()) {
                this.appContext.getCronJobQueue().remove(jobPo.getJobId());
            } else if (jobPo.isRepeatable()) {
                this.appContext.getRepeatJobQueue().remove(jobPo.getJobId());
            }
            JobLogPo jobLogPo = JobDomainConverter.convertJobLog((JobPo)jobPo);
            jobLogPo.setSuccess(true);
            jobLogPo.setLogType(LogType.DEL);
            jobLogPo.setLogTime(Long.valueOf(SystemClock.now()));
            jobLogPo.setLevel(Level.INFO);
            this.appContext.getJobLogger().log(jobLogPo);
            this.LOGGER.info("Cancel Job success , jobId={}, taskId={}, taskTrackerNodeGroup={}", new Object[]{jobPo.getJobId(), taskId, taskTrackerNodeGroup});
            return RemotingCommand.createResponseCommand((int)JobProtos.ResponseCode.JOB_CANCEL_SUCCESS.code());
        }
        return RemotingCommand.createResponseCommand((int)JobProtos.ResponseCode.JOB_CANCEL_FAILED.code(), (String)"Job maybe running");
    }
}

