/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.processor;

import com.github.ltsopensource.core.exception.JobReceiveException;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.protocol.JobProtos;
import com.github.ltsopensource.core.protocol.command.AbstractRemotingCommandBody;
import com.github.ltsopensource.core.protocol.command.JobSubmitRequest;
import com.github.ltsopensource.core.protocol.command.JobSubmitResponse;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;
import com.github.ltsopensource.jobtracker.processor.AbstractRemotingProcessor;
import com.github.ltsopensource.remoting.Channel;
import com.github.ltsopensource.remoting.RemotingCommandBody;
import com.github.ltsopensource.remoting.exception.RemotingCommandException;
import com.github.ltsopensource.remoting.protocol.RemotingCommand;

public class JobSubmitProcessor
extends AbstractRemotingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSubmitProcessor.class);

    public JobSubmitProcessor(JobTrackerAppContext appContext) {
        super(appContext);
    }

    public RemotingCommand processRequest(Channel channel, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response;
        JobSubmitRequest jobSubmitRequest = (JobSubmitRequest)request.getBody();
        JobSubmitResponse jobSubmitResponse = (JobSubmitResponse)this.appContext.getCommandBodyWrapper().wrapper((AbstractRemotingCommandBody)new JobSubmitResponse());
        try {
            this.appContext.getJobReceiver().receive(jobSubmitRequest);
            response = RemotingCommand.createResponseCommand((int)JobProtos.ResponseCode.JOB_RECEIVE_SUCCESS.code(), (String)"job submit success!", (RemotingCommandBody)jobSubmitResponse);
        }
        catch (JobReceiveException e) {
            LOGGER.error("Receive job failed , jobs = " + jobSubmitRequest.getJobs(), (Throwable)e);
            jobSubmitResponse.setSuccess(Boolean.valueOf(false));
            jobSubmitResponse.setMsg(e.getMessage());
            jobSubmitResponse.setFailedJobs(e.getJobs());
            response = RemotingCommand.createResponseCommand((int)JobProtos.ResponseCode.JOB_RECEIVE_FAILED.code(), (String)e.getMessage(), (RemotingCommandBody)jobSubmitResponse);
        }
        return response;
    }
}

