/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.sender;

import com.github.ltsopensource.biz.logger.domain.JobLogPo;
import com.github.ltsopensource.biz.logger.domain.LogType;
import com.github.ltsopensource.core.constant.Level;
import com.github.ltsopensource.core.json.JSON;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.support.JobDomainConverter;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;
import com.github.ltsopensource.jobtracker.sender.JobPushResult;
import com.github.ltsopensource.queue.domain.JobPo;
import com.github.ltsopensource.store.jdbc.exception.DupEntryException;

public class JobSender {
    private final Logger LOGGER = LoggerFactory.getLogger(JobSender.class);
    private JobTrackerAppContext appContext;

    public JobSender(JobTrackerAppContext appContext) {
        this.appContext = appContext;
    }

    public SendResult send(String taskTrackerNodeGroup, String taskTrackerIdentity, SendInvoker invoker) {
        JobPo jobPo = this.appContext.getPreLoader().take(taskTrackerNodeGroup, taskTrackerIdentity);
        if (jobPo == null) {
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("Job push failed: no job! nodeGroup=" + taskTrackerNodeGroup + ", identity=" + taskTrackerIdentity);
            }
            return new SendResult(false, (Object)JobPushResult.NO_JOB);
        }
        try {
            jobPo.setGmtModified(jobPo.getGmtCreated());
            this.appContext.getExecutingJobQueue().add(jobPo);
        }
        catch (DupEntryException e) {
            this.LOGGER.warn("ExecutingJobQueue already exist:" + JSON.toJSONString((Object)jobPo));
            this.appContext.getExecutableJobQueue().resume(jobPo);
            return new SendResult(false, (Object)JobPushResult.FAILED);
        }
        this.appContext.getExecutableJobQueue().remove(jobPo.getTaskTrackerNodeGroup(), jobPo.getJobId());
        SendResult sendResult = invoker.invoke(jobPo);
        if (sendResult.isSuccess()) {
            JobLogPo jobLogPo = JobDomainConverter.convertJobLog((JobPo)jobPo);
            jobLogPo.setSuccess(true);
            jobLogPo.setLogType(LogType.SENT);
            jobLogPo.setLogTime(Long.valueOf(SystemClock.now()));
            jobLogPo.setLevel(Level.INFO);
            this.appContext.getJobLogger().log(jobLogPo);
        }
        return sendResult;
    }

    public static class SendResult {
        private boolean success;
        private Object returnValue;

        public SendResult(boolean success, Object returnValue) {
            this.success = success;
            this.returnValue = returnValue;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public Object getReturnValue() {
            return this.returnValue;
        }

        public void setReturnValue(Object returnValue) {
            this.returnValue = returnValue;
        }
    }

    public static interface SendInvoker {
        public SendResult invoke(JobPo var1);
    }
}

