/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.support;

import com.github.ltsopensource.core.commons.utils.Holder;
import com.github.ltsopensource.core.constant.Constants;
import com.github.ltsopensource.core.exception.RemotingSendException;
import com.github.ltsopensource.core.exception.RequestTimeoutException;
import com.github.ltsopensource.core.factory.NamedThreadFactory;
import com.github.ltsopensource.core.json.JSON;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.protocol.JobProtos;
import com.github.ltsopensource.core.protocol.command.AbstractRemotingCommandBody;
import com.github.ltsopensource.core.protocol.command.JobPullRequest;
import com.github.ltsopensource.core.protocol.command.JobPushRequest;
import com.github.ltsopensource.core.remoting.RemotingServerDelegate;
import com.github.ltsopensource.core.support.JobDomainConverter;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;
import com.github.ltsopensource.jobtracker.domain.TaskTrackerNode;
import com.github.ltsopensource.jobtracker.monitor.JobTrackerMStatReporter;
import com.github.ltsopensource.jobtracker.sender.JobPushResult;
import com.github.ltsopensource.jobtracker.sender.JobSender;
import com.github.ltsopensource.queue.domain.JobPo;
import com.github.ltsopensource.remoting.AsyncCallback;
import com.github.ltsopensource.remoting.RemotingCommandBody;
import com.github.ltsopensource.remoting.ResponseFuture;
import com.github.ltsopensource.remoting.protocol.RemotingCommand;
import com.github.ltsopensource.store.jdbc.exception.DupEntryException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class JobPusher {
    private final Logger LOGGER = LoggerFactory.getLogger(JobPusher.class);
    private JobTrackerAppContext appContext;
    private final ExecutorService executorService;
    private JobTrackerMStatReporter stat;
    private RemotingServerDelegate remotingServer;

    public JobPusher(JobTrackerAppContext appContext) {
        this.appContext = appContext;
        this.executorService = Executors.newFixedThreadPool(Constants.AVAILABLE_PROCESSOR * 5, (ThreadFactory)new NamedThreadFactory(JobPusher.class.getSimpleName(), true));
        this.stat = (JobTrackerMStatReporter)appContext.getMStatReporter();
        this.remotingServer = appContext.getRemotingServer();
    }

    public void concurrentPush(final JobPullRequest request) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    JobPusher.this.push(request);
                }
                catch (Exception e) {
                    JobPusher.this.LOGGER.error("Job push failed!", (Throwable)e);
                }
            }
        });
    }

    private void push(JobPullRequest request) {
        String nodeGroup = request.getNodeGroup();
        String identity = request.getIdentity();
        this.appContext.getTaskTrackerManager().updateTaskTrackerAvailableThreads(nodeGroup, identity, request.getAvailableThreads(), request.getTimestamp());
        TaskTrackerNode taskTrackerNode = this.appContext.getTaskTrackerManager().getTaskTrackerNode(nodeGroup, identity);
        if (taskTrackerNode == null) {
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("taskTrackerNodeGroup:{}, taskTrackerIdentity:{} , didn't have node.", new Object[]{nodeGroup, identity});
            }
            return;
        }
        int availableThreads = taskTrackerNode.getAvailableThread().get();
        if (availableThreads == 0 && this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("taskTrackerNodeGroup:{}, taskTrackerIdentity:{} , availableThreads:0", new Object[]{nodeGroup, identity});
        }
        while (availableThreads > 0) {
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("taskTrackerNodeGroup:{}, taskTrackerIdentity:{} , availableThreads:{}", new Object[]{nodeGroup, identity, availableThreads});
            }
            JobPushResult result = this.send(this.remotingServer, taskTrackerNode);
            switch (result) {
                case SUCCESS: {
                    availableThreads = taskTrackerNode.getAvailableThread().decrementAndGet();
                    this.stat.incPushJobNum();
                    break;
                }
                case FAILED: {
                    break;
                }
                case NO_JOB: {
                    return;
                }
                case SENT_ERROR: {
                    return;
                }
            }
        }
    }

    private JobPushResult send(final RemotingServerDelegate remotingServer, final TaskTrackerNode taskTrackerNode) {
        final String nodeGroup = taskTrackerNode.getNodeGroup();
        final String identity = taskTrackerNode.getIdentity();
        JobSender.SendResult sendResult = this.appContext.getJobSender().send(nodeGroup, identity, new JobSender.SendInvoker(){

            @Override
            public JobSender.SendResult invoke(final JobPo jobPo) {
                JobPushRequest body = (JobPushRequest)JobPusher.this.appContext.getCommandBodyWrapper().wrapper((AbstractRemotingCommandBody)new JobPushRequest());
                body.setJobMeta(JobDomainConverter.convert((JobPo)jobPo));
                RemotingCommand commandRequest = RemotingCommand.createRequestCommand((int)JobProtos.RequestCode.PUSH_JOB.code(), (RemotingCommandBody)body);
                final Holder pushSuccess = new Holder((Object)false);
                final CountDownLatch latch = new CountDownLatch(1);
                try {
                    remotingServer.invokeAsync(taskTrackerNode.getChannel().getChannel(), commandRequest, new AsyncCallback(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void operationComplete(ResponseFuture responseFuture) {
                            try {
                                RemotingCommand responseCommand = responseFuture.getResponseCommand();
                                if (responseCommand == null) {
                                    JobPusher.this.LOGGER.warn("Job push failed! response command is null!");
                                    return;
                                }
                                if (responseCommand.getCode() == JobProtos.ResponseCode.JOB_PUSH_SUCCESS.code()) {
                                    if (JobPusher.this.LOGGER.isDebugEnabled()) {
                                        JobPusher.this.LOGGER.debug("Job push success! nodeGroup=" + nodeGroup + ", identity=" + identity + ", job=" + jobPo);
                                    }
                                    pushSuccess.set((Object)true);
                                }
                            }
                            finally {
                                latch.countDown();
                            }
                        }
                    });
                }
                catch (RemotingSendException e) {
                    JobPusher.this.LOGGER.error("Remoting send error, jobPo={}", new Object[]{jobPo, e});
                    return new JobSender.SendResult(false, (Object)JobPushResult.SENT_ERROR);
                }
                try {
                    latch.await(60000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    throw new RequestTimeoutException((Throwable)e);
                }
                if (!((Boolean)pushSuccess.get()).booleanValue()) {
                    if (JobPusher.this.LOGGER.isDebugEnabled()) {
                        JobPusher.this.LOGGER.debug("Job push failed! nodeGroup=" + nodeGroup + ", identity=" + identity + ", job=" + jobPo);
                    }
                    boolean needResume = true;
                    try {
                        jobPo.setIsRunning(Boolean.valueOf(true));
                        jobPo.setGmtModified(Long.valueOf(SystemClock.now()));
                        JobPusher.this.appContext.getExecutableJobQueue().add(jobPo);
                    }
                    catch (DupEntryException e) {
                        JobPusher.this.LOGGER.warn("ExecutableJobQueue already exist:" + JSON.toJSONString((Object)jobPo));
                        needResume = false;
                    }
                    JobPusher.this.appContext.getExecutingJobQueue().remove(jobPo.getJobId());
                    if (needResume) {
                        JobPusher.this.appContext.getExecutableJobQueue().resume(jobPo);
                    }
                    return new JobSender.SendResult(false, (Object)JobPushResult.SENT_ERROR);
                }
                return new JobSender.SendResult(true, (Object)JobPushResult.SUCCESS);
            }
        });
        return (JobPushResult)((Object)sendResult.getReturnValue());
    }
}

