/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.support;

import com.github.ltsopensource.biz.logger.domain.JobLogPo;
import com.github.ltsopensource.biz.logger.domain.LogType;
import com.github.ltsopensource.core.commons.utils.Assert;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.constant.Level;
import com.github.ltsopensource.core.domain.Job;
import com.github.ltsopensource.core.exception.JobReceiveException;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.protocol.command.JobSubmitRequest;
import com.github.ltsopensource.core.support.CronExpressionUtils;
import com.github.ltsopensource.core.support.JobDomainConverter;
import com.github.ltsopensource.core.support.JobUtils;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;
import com.github.ltsopensource.jobtracker.monitor.JobTrackerMStatReporter;
import com.github.ltsopensource.queue.domain.JobPo;
import com.github.ltsopensource.store.jdbc.exception.DupEntryException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class JobReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobReceiver.class);
    private JobTrackerAppContext appContext;
    private JobTrackerMStatReporter stat;

    public JobReceiver(JobTrackerAppContext appContext) {
        this.appContext = appContext;
        this.stat = (JobTrackerMStatReporter)appContext.getMStatReporter();
    }

    public void receive(JobSubmitRequest request) throws JobReceiveException {
        List jobs = request.getJobs();
        if (CollectionUtils.isEmpty((Collection)jobs)) {
            return;
        }
        JobReceiveException exception = null;
        for (Job job : jobs) {
            try {
                this.addToQueue(job, request);
            }
            catch (Exception e) {
                if (exception == null) {
                    exception = new JobReceiveException((Throwable)e);
                }
                exception.addJob(job);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private JobPo addToQueue(Job job, JobSubmitRequest request) {
        block15: {
            block13: {
                block14: {
                    jobPo = null;
                    success = false;
                    code = null;
                    jobPo = JobDomainConverter.convert((Job)job);
                    if (jobPo != null) break block13;
                    JobReceiver.LOGGER.warn("Job can not be null\u3002{}", new Object[]{job});
                    var6_6 = null;
                    if (!success) break block14;
                    this.stat.incReceiveJobNum();
                    if (JobReceiver.LOGGER.isDebugEnabled()) {
                        JobReceiver.LOGGER.debug("Receive Job success. {}", new Object[]{job});
                    }
                }
                return var6_6;
            }
            try {
                if (StringUtils.isEmpty((String)jobPo.getSubmitNodeGroup())) {
                    jobPo.setSubmitNodeGroup(request.getNodeGroup());
                }
                jobPo.setJobId(JobUtils.generateJobId());
                this.addJob(job, jobPo);
                success = true;
                code = BizLogCode.SUCCESS;
                if (!success) break block15;
                this.stat.incReceiveJobNum();
            }
            catch (DupEntryException e) {
                try {
                    if (job.isReplaceOnExist()) {
                        Assert.notNull((Object)jobPo);
                        success = this.replaceOnExist(job, jobPo);
                        code = success != false ? BizLogCode.DUP_REPLACE : BizLogCode.DUP_FAILED;
                    } else {
                        code = BizLogCode.DUP_IGNORE;
                        JobReceiver.LOGGER.info("Job already exist And ignore. nodeGroup={}, {}", new Object[]{request.getNodeGroup(), job});
                    }
                    if (!success) break block15;
                    this.stat.incReceiveJobNum();
                }
                catch (Throwable var7_8) {
                    if (success) {
                        this.stat.incReceiveJobNum();
                        if (JobReceiver.LOGGER.isDebugEnabled()) {
                            JobReceiver.LOGGER.debug("Receive Job success. {}", new Object[]{job});
                        }
                    }
                    throw var7_8;
                }
                if (JobReceiver.LOGGER.isDebugEnabled()) {
                    JobReceiver.LOGGER.debug("Receive Job success. {}", new Object[]{job});
                } else {
                    ** GOTO lbl48
                }
            }
            if (JobReceiver.LOGGER.isDebugEnabled()) {
                JobReceiver.LOGGER.debug("Receive Job success. {}", new Object[]{job});
            }
        }
        this.jobBizLog(jobPo, code);
        return jobPo;
    }

    private void addJob(Job job, JobPo jobPo) throws DupEntryException {
        if (job.isCron()) {
            this.addCronJob(jobPo);
        } else if (job.isRepeatable()) {
            this.addRepeatJob(jobPo);
        } else {
            boolean needAdd2ExecutableJobQueue = true;
            String ignoreAddOnExecuting = (String)CollectionUtils.getValue((Map)jobPo.getInternalExtParams(), (Object)"__LTS_ignoreAddOnExecuting");
            if (ignoreAddOnExecuting != null && "true".equals(ignoreAddOnExecuting) && this.appContext.getExecutingJobQueue().getJob(jobPo.getTaskTrackerNodeGroup(), jobPo.getTaskId()) != null) {
                needAdd2ExecutableJobQueue = false;
            }
            if (needAdd2ExecutableJobQueue) {
                this.appContext.getExecutableJobQueue().add(jobPo);
            }
        }
    }

    private boolean replaceOnExist(Job job, JobPo jobPo) {
        JobPo oldJobPo = job.isCron() ? this.appContext.getCronJobQueue().getJob(job.getTaskTrackerNodeGroup(), job.getTaskId()) : (job.isRepeatable() ? this.appContext.getRepeatJobQueue().getJob(job.getTaskTrackerNodeGroup(), job.getTaskId()) : this.appContext.getExecutableJobQueue().getJob(job.getTaskTrackerNodeGroup(), job.getTaskId()));
        if (oldJobPo != null) {
            String jobId = oldJobPo.getJobId();
            this.appContext.getExecutableJobQueue().remove(job.getTaskTrackerNodeGroup(), jobId);
            if (job.isCron()) {
                this.appContext.getCronJobQueue().remove(jobId);
            } else if (job.isRepeatable()) {
                this.appContext.getRepeatJobQueue().remove(jobId);
            }
            jobPo.setJobId(jobId);
        }
        try {
            this.addJob(job, jobPo);
        }
        catch (DupEntryException e) {
            LOGGER.warn("Job already exist twice. {}", new Object[]{job});
            return false;
        }
        return true;
    }

    private void addCronJob(JobPo jobPo) throws DupEntryException {
        Date nextTriggerTime = CronExpressionUtils.getNextTriggerTime((String)jobPo.getCronExpression());
        if (nextTriggerTime != null) {
            this.appContext.getCronJobQueue().add(jobPo);
            if (JobUtils.isRelyOnPrevCycle((JobPo)jobPo)) {
                if (this.appContext.getExecutingJobQueue().getJob(jobPo.getTaskTrackerNodeGroup(), jobPo.getTaskId()) == null) {
                    jobPo.setTriggerTime(Long.valueOf(nextTriggerTime.getTime()));
                    this.appContext.getExecutableJobQueue().add(jobPo);
                }
            } else {
                this.appContext.getNonRelyOnPrevCycleJobScheduler().addScheduleJobForOneHour(jobPo);
            }
        }
    }

    private void addRepeatJob(JobPo jobPo) throws DupEntryException {
        this.appContext.getRepeatJobQueue().add(jobPo);
        if (JobUtils.isRelyOnPrevCycle((JobPo)jobPo)) {
            if (this.appContext.getExecutingJobQueue().getJob(jobPo.getTaskTrackerNodeGroup(), jobPo.getTaskId()) == null) {
                this.appContext.getExecutableJobQueue().add(jobPo);
            }
        } else {
            this.appContext.getNonRelyOnPrevCycleJobScheduler().addScheduleJobForOneHour(jobPo);
        }
    }

    private void jobBizLog(JobPo jobPo, BizLogCode code) {
        if (jobPo == null) {
            return;
        }
        try {
            JobLogPo jobLogPo = JobDomainConverter.convertJobLog((JobPo)jobPo);
            jobLogPo.setSuccess(true);
            jobLogPo.setLogType(LogType.RECEIVE);
            jobLogPo.setLogTime(Long.valueOf(SystemClock.now()));
            switch (code) {
                case SUCCESS: {
                    jobLogPo.setLevel(Level.INFO);
                    jobLogPo.setMsg("Receive Success");
                    break;
                }
                case DUP_IGNORE: {
                    jobLogPo.setLevel(Level.WARN);
                    jobLogPo.setMsg("Already Exist And Ignored");
                    break;
                }
                case DUP_FAILED: {
                    jobLogPo.setLevel(Level.ERROR);
                    jobLogPo.setMsg("Already Exist And Update Failed");
                    break;
                }
                case DUP_REPLACE: {
                    jobLogPo.setLevel(Level.INFO);
                    jobLogPo.setMsg("Already Exist And Update Success");
                }
            }
            this.appContext.getJobLogger().log(jobLogPo);
        }
        catch (Throwable t) {
            LOGGER.error("Receive Job Log error ", t);
        }
    }

    private static enum BizLogCode {
        DUP_IGNORE,
        DUP_REPLACE,
        DUP_FAILED,
        SUCCESS;

    }
}

