/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.support.cluster;

import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.cluster.Node;
import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.commons.concurrent.ConcurrentHashSet;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.loadbalance.LoadBalance;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.spi.ServiceLoader;
import com.github.ltsopensource.jobtracker.channel.ChannelWrapper;
import com.github.ltsopensource.jobtracker.domain.JobClientNode;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class JobClientManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobClientManager.class);
    private final ConcurrentHashMap<String, Set<JobClientNode>> NODE_MAP = new ConcurrentHashMap();
    private LoadBalance loadBalance;
    private JobTrackerAppContext appContext;

    public JobClientManager(JobTrackerAppContext appContext) {
        this.appContext = appContext;
        this.loadBalance = (LoadBalance)ServiceLoader.load(LoadBalance.class, (Config)appContext.getConfig(), (String)"jobclient.select.loadbalance");
    }

    public Set<String> getNodeGroups() {
        return this.NODE_MAP.keySet();
    }

    public void addNode(Node node) {
        ChannelWrapper channel = this.appContext.getChannelManager().getChannel(node.getGroup(), node.getNodeType(), node.getIdentity());
        Object jobClientNodes = this.NODE_MAP.get(node.getGroup());
        if (jobClientNodes == null) {
            jobClientNodes = new ConcurrentHashSet();
            Set<JobClientNode> oldSet = this.NODE_MAP.putIfAbsent(node.getGroup(), (Set<JobClientNode>)jobClientNodes);
            if (oldSet != null) {
                jobClientNodes = oldSet;
            }
        }
        JobClientNode jobClientNode = new JobClientNode(node.getGroup(), node.getIdentity(), channel);
        LOGGER.info("add JobClient node:{}", new Object[]{jobClientNode});
        jobClientNodes.add(jobClientNode);
        this.appContext.getJobFeedbackQueue().createQueue(node.getGroup());
        this.appContext.getNodeGroupStore().addNodeGroup(NodeType.JOB_CLIENT, node.getGroup());
    }

    public void removeNode(Node node) {
        Set<JobClientNode> jobClientNodes = this.NODE_MAP.get(node.getGroup());
        if (jobClientNodes != null && jobClientNodes.size() != 0) {
            for (JobClientNode jobClientNode : jobClientNodes) {
                if (!node.getIdentity().equals(jobClientNode.getIdentity())) continue;
                LOGGER.info("remove JobClient node:{}", new Object[]{jobClientNode});
                jobClientNodes.remove(jobClientNode);
            }
        }
    }

    public JobClientNode getAvailableJobClient(String nodeGroup) {
        Set<JobClientNode> jobClientNodes = this.NODE_MAP.get(nodeGroup);
        if (CollectionUtils.isEmpty(jobClientNodes)) {
            return null;
        }
        ArrayList<JobClientNode> list = new ArrayList<JobClientNode>(jobClientNodes);
        while (list.size() > 0) {
            ChannelWrapper channel;
            JobClientNode jobClientNode = (JobClientNode)this.loadBalance.select(list, null);
            if (jobClientNode != null && (jobClientNode.getChannel() == null || jobClientNode.getChannel().isClosed()) && (channel = this.appContext.getChannelManager().getChannel(jobClientNode.getNodeGroup(), NodeType.JOB_CLIENT, jobClientNode.getIdentity())) != null) {
                jobClientNode.setChannel(channel);
            }
            if (jobClientNode != null && jobClientNode.getChannel() != null && !jobClientNode.getChannel().isClosed()) {
                return jobClientNode;
            }
            list.remove(jobClientNode);
        }
        return null;
    }
}

