/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time.converter;

import com.xkzhangsan.time.LunarDate;
import com.xkzhangsan.time.calculator.DateTimeCalculatorUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class DateTimeConverterUtil {
    private DateTimeConverterUtil() {
    }

    public static Date toDate(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(LocalTime localTime) {
        Objects.requireNonNull(localTime, "localTime");
        return Date.from(LocalDate.now().atTime(localTime).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(Instant instant) {
        return Date.from(instant);
    }

    public static Date toDate(long epochMilli) {
        Objects.requireNonNull(Long.valueOf(epochMilli), "epochMilli");
        return new Date(epochMilli);
    }

    public static Date toDate(ZonedDateTime zonedDateTime) {
        Objects.requireNonNull(zonedDateTime, "zonedDateTime");
        return Date.from(zonedDateTime.toInstant());
    }

    public static Date toDate(TemporalAccessor temporal) {
        return DateTimeConverterUtil.toDate(DateTimeConverterUtil.toZonedDateTime(temporal));
    }

    public static Date toDate(YearMonth yearMonth, int dayOfMonth) {
        Objects.requireNonNull(yearMonth, "yearMonth");
        return DateTimeConverterUtil.toDate(yearMonth.atDay(dayOfMonth));
    }

    public static Date toDateStartOfMonth(YearMonth yearMonth) {
        return DateTimeConverterUtil.toDate(yearMonth, 1);
    }

    public static Date toDateEndOfMonth(YearMonth yearMonth) {
        Objects.requireNonNull(yearMonth, "yearMonth");
        return DateTimeConverterUtil.toDate(yearMonth.atEndOfMonth());
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        Objects.requireNonNull(date, "date");
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(Timestamp timestamp) {
        Objects.requireNonNull(timestamp, "timestamp");
        return timestamp.toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.atStartOfDay();
    }

    public static LocalDateTime toLocalDateTime(LocalTime localTime) {
        Objects.requireNonNull(localTime, "localTime");
        return LocalDate.now().atTime(localTime);
    }

    public static LocalDateTime toLocalDateTime(Instant instant) {
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(long epochMilli) {
        Objects.requireNonNull(Long.valueOf(epochMilli), "epochMilli");
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(TemporalAccessor temporal) {
        return DateTimeConverterUtil.toLocalDateTime(DateTimeConverterUtil.toZonedDateTime(temporal));
    }

    public static LocalDateTime toLocalDateTime(ZonedDateTime zonedDateTime) {
        Objects.requireNonNull(zonedDateTime, "zonedDateTime");
        return zonedDateTime.toLocalDateTime();
    }

    public static LocalDate toLocalDate(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).toLocalDate();
    }

    public static LocalDate toLocalDate(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.toLocalDate();
    }

    public static LocalDate toLocalDate(Instant instant) {
        return DateTimeConverterUtil.toLocalDateTime(instant).toLocalDate();
    }

    public static LocalDate toLocalDate(long epochMilli) {
        Objects.requireNonNull(Long.valueOf(epochMilli), "epochMilli");
        return DateTimeConverterUtil.toLocalDateTime(epochMilli).toLocalDate();
    }

    public static LocalDate toLocalDate(TemporalAccessor temporal) {
        return DateTimeConverterUtil.toLocalDate(DateTimeConverterUtil.toZonedDateTime(temporal));
    }

    public static LocalDate toLocalDate(ZonedDateTime zonedDateTime) {
        Objects.requireNonNull(zonedDateTime, "zonedDateTime");
        return zonedDateTime.toLocalDate();
    }

    public static LocalDate toLocalDate(YearMonth yearMonth, int dayOfMonth) {
        Objects.requireNonNull(yearMonth, "yearMonth");
        return yearMonth.atDay(dayOfMonth);
    }

    public static LocalDate toLocalDateStartOfMonth(YearMonth yearMonth) {
        return DateTimeConverterUtil.toLocalDate(yearMonth, 1);
    }

    public static LocalDate toLocalDateEndOfMonth(YearMonth yearMonth) {
        Objects.requireNonNull(yearMonth, "yearMonth");
        return yearMonth.atEndOfMonth();
    }

    public static LocalTime toLocalTime(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).toLocalTime();
    }

    public static LocalTime toLocalTime(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.toLocalTime();
    }

    public static LocalTime toLocalTime(Instant instant) {
        return DateTimeConverterUtil.toLocalDateTime(instant).toLocalTime();
    }

    public static LocalTime toLocalTime(TemporalAccessor temporal) {
        return DateTimeConverterUtil.toLocalTime(DateTimeConverterUtil.toZonedDateTime(temporal));
    }

    public static LocalTime toLocalTime(ZonedDateTime zonedDateTime) {
        Objects.requireNonNull(zonedDateTime, "zonedDateTime");
        return zonedDateTime.toLocalTime();
    }

    public static LocalTime toLocalTime(long epochMilli) {
        return DateTimeConverterUtil.toLocalDateTime(epochMilli).toLocalTime();
    }

    public static LocalTime toLocalTime(int timeMilli) {
        return LocalTime.ofNanoOfDay((long)timeMilli * 1000000L);
    }

    public static int toTimeMilli(LocalTime localTime) {
        Objects.requireNonNull(localTime, "localTime");
        return (int)(localTime.toNanoOfDay() / 1000000L);
    }

    public static Instant toInstant(Date date) {
        Objects.requireNonNull(date, "date");
        return date.toInstant();
    }

    public static Instant toInstant(Timestamp timestamp) {
        Objects.requireNonNull(timestamp, "timestamp");
        return timestamp.toInstant();
    }

    public static Instant toInstant(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant();
    }

    public static Instant toInstant(LocalDate localDate) {
        return DateTimeConverterUtil.toLocalDateTime(localDate).atZone(ZoneId.systemDefault()).toInstant();
    }

    public static Instant toInstant(LocalTime localTime) {
        return DateTimeConverterUtil.toLocalDateTime(localTime).atZone(ZoneId.systemDefault()).toInstant();
    }

    public static Instant toInstant(long epochMilli) {
        Objects.requireNonNull(Long.valueOf(epochMilli), "epochMilli");
        return Instant.ofEpochMilli(epochMilli);
    }

    public static Instant toInstant(TemporalAccessor temporal) {
        return DateTimeConverterUtil.toInstant(DateTimeConverterUtil.toZonedDateTime(temporal));
    }

    public static Instant toInstant(ZonedDateTime zonedDateTime) {
        Objects.requireNonNull(zonedDateTime, "zonedDateTime");
        return zonedDateTime.toInstant();
    }

    public static long toEpochMilli(Date date) {
        Objects.requireNonNull(date, "date");
        return date.getTime();
    }

    public static long toEpochMilli(Timestamp timestamp) {
        Objects.requireNonNull(timestamp, "timestamp");
        return timestamp.getTime();
    }

    public static long toEpochMilli(LocalDateTime localDateTime) {
        return DateTimeConverterUtil.toInstant(localDateTime).toEpochMilli();
    }

    public static long toEpochMilli(LocalDate localDate) {
        return DateTimeConverterUtil.toInstant(localDate).toEpochMilli();
    }

    public static long toEpochMilli(LocalTime localTime) {
        return DateTimeConverterUtil.toInstant(localTime).toEpochMilli();
    }

    public static long toEpochMilli(Instant instant) {
        Objects.requireNonNull(instant, "instant");
        return instant.toEpochMilli();
    }

    public static long toEpochMilli(ZonedDateTime zonedDateTime) {
        Objects.requireNonNull(zonedDateTime, "zonedDateTime");
        return zonedDateTime.toInstant().toEpochMilli();
    }

    public static long toEpochMilli(TemporalAccessor temporal) {
        return DateTimeConverterUtil.toEpochMilli(DateTimeConverterUtil.toZonedDateTime(temporal));
    }

    public static ZonedDateTime toZonedDateTime(Date date) {
        Objects.requireNonNull(date, "date");
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault());
    }

    public static ZonedDateTime toZonedDateTime(Date date, String zoneId) {
        Objects.requireNonNull(zoneId, "zoneId");
        return DateTimeConverterUtil.toZonedDateTime(date, ZoneId.of(zoneId));
    }

    public static ZonedDateTime toZonedDateTime(Date date, ZoneId zone) {
        Objects.requireNonNull(date, "date");
        Objects.requireNonNull(zone, "zone");
        return Instant.ofEpochMilli(date.getTime()).atZone(zone);
    }

    public static ZonedDateTime toZonedDateTime(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.atZone(ZoneId.systemDefault());
    }

    public static ZonedDateTime toZonedDateTime(LocalDateTime localDateTime, String zoneId) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        Objects.requireNonNull(zoneId, "zoneId");
        return localDateTime.atZone(ZoneId.of(zoneId));
    }

    public static ZonedDateTime toZonedDateTimeAndTransformZone(LocalDateTime localDateTime, String targetZoneId) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        Objects.requireNonNull(targetZoneId, "targetZoneId");
        return DateTimeCalculatorUtil.transform(localDateTime.atZone(ZoneId.systemDefault()), targetZoneId);
    }

    public static ZonedDateTime toZonedDateTime(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.atStartOfDay().atZone(ZoneId.systemDefault());
    }

    public static ZonedDateTime toZonedDateTime(LocalTime localTime) {
        Objects.requireNonNull(localTime, "localTime");
        return LocalDate.now().atTime(localTime).atZone(ZoneId.systemDefault());
    }

    public static ZonedDateTime toZonedDateTime(Instant instant) {
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).atZone(ZoneId.systemDefault());
    }

    public static ZonedDateTime toZonedDateTime(long epochMilli) {
        Objects.requireNonNull(Long.valueOf(epochMilli), "epochMilli");
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), ZoneId.systemDefault()).atZone(ZoneId.systemDefault());
    }

    public static ZonedDateTime toZonedDateTime(TemporalAccessor temporal) {
        Objects.requireNonNull(temporal, "temporal");
        if (temporal instanceof Instant) {
            return DateTimeConverterUtil.toZonedDateTime((Instant)temporal);
        }
        if (temporal instanceof LocalDate) {
            return DateTimeConverterUtil.toZonedDateTime((LocalDate)temporal);
        }
        if (temporal instanceof LocalDateTime) {
            return DateTimeConverterUtil.toZonedDateTime((LocalDateTime)temporal);
        }
        if (temporal instanceof LocalTime) {
            return DateTimeConverterUtil.toZonedDateTime((LocalTime)temporal);
        }
        if (temporal instanceof ZonedDateTime) {
            return (ZonedDateTime)temporal;
        }
        if (temporal instanceof YearMonth) {
            return DateTimeConverterUtil.toZonedDateTime((YearMonth)temporal);
        }
        if (temporal instanceof OffsetDateTime) {
            return ((OffsetDateTime)temporal).toZonedDateTime();
        }
        if (temporal instanceof OffsetTime) {
            return ((OffsetTime)temporal).atDate(LocalDate.now()).toZonedDateTime();
        }
        if (temporal instanceof LunarDate) {
            return DateTimeConverterUtil.toZonedDateTime(((LunarDate)temporal).getLocalDate());
        }
        return ZonedDateTime.from(temporal);
    }

    public static YearMonth toYearMonth(Date date) {
        LocalDate localDate = DateTimeConverterUtil.toLocalDate(date);
        return YearMonth.of(localDate.getYear(), localDate.getMonthValue());
    }

    public static YearMonth toYearMonth(LocalDateTime localDateTime) {
        LocalDate localDate = DateTimeConverterUtil.toLocalDate(localDateTime);
        return YearMonth.of(localDate.getYear(), localDate.getMonthValue());
    }

    public static YearMonth toYearMonth(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return YearMonth.of(localDate.getYear(), localDate.getMonthValue());
    }

    public static YearMonth toYearMonth(Instant instant) {
        LocalDate localDate = DateTimeConverterUtil.toLocalDate(instant);
        return YearMonth.of(localDate.getYear(), localDate.getMonthValue());
    }

    public static YearMonth toYearMonth(ZonedDateTime zonedDateTime) {
        LocalDate localDate = DateTimeConverterUtil.toLocalDate(zonedDateTime);
        return YearMonth.of(localDate.getYear(), localDate.getMonthValue());
    }

    public static YearMonth toYearMonth(TemporalAccessor temporal) {
        return DateTimeConverterUtil.toYearMonth(DateTimeConverterUtil.toZonedDateTime(temporal));
    }

    public static Timestamp toTimestamp(Date date) {
        Objects.requireNonNull(date, "date");
        return new Timestamp(date.getTime());
    }

    public static Timestamp toTimestamp(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return Timestamp.valueOf(localDateTime);
    }

    public static Timestamp toTimestamp(Instant instant) {
        Objects.requireNonNull(instant, "instant");
        return Timestamp.from(instant);
    }

    public static Timestamp toTimestamp(long epochMilli) {
        return new Timestamp(epochMilli);
    }

    public static Timestamp toTimestamp(ZonedDateTime zonedDateTime) {
        Objects.requireNonNull(zonedDateTime, "zonedDateTime");
        return DateTimeConverterUtil.toTimestamp(DateTimeConverterUtil.toLocalDateTime(zonedDateTime));
    }

    public static Timestamp toTimestamp(TemporalAccessor temporal) {
        return DateTimeConverterUtil.toTimestamp(DateTimeConverterUtil.toZonedDateTime(temporal));
    }

    public static long unitConversion(long sourceDuration, TimeUnit sourceUnit, TimeUnit targetUnit) {
        return targetUnit.convert(sourceDuration, sourceUnit);
    }

    public static BigDecimal unitConversionPrecise(long sourceDuration, TimeUnit sourceUnit, TimeUnit targetUnit, int scale, RoundingMode roundingMode) {
        return BigDecimal.valueOf(sourceDuration).multiply(BigDecimal.valueOf(sourceUnit.toNanos(1L))).divide(BigDecimal.valueOf(targetUnit.toNanos(1L)), scale, roundingMode);
    }

    public static String unitConversionPreciseString(long sourceDuration, TimeUnit sourceUnit, TimeUnit targetUnit, int scale, RoundingMode roundingMode) {
        return DateTimeConverterUtil.unitConversionPrecise(sourceDuration, sourceUnit, targetUnit, scale, roundingMode).stripTrailingZeros().toPlainString();
    }

    public static BigDecimal unitConversionPrecise(long sourceDuration, TimeUnit sourceUnit, TimeUnit targetUnit) {
        return DateTimeConverterUtil.unitConversionPrecise(sourceDuration, sourceUnit, targetUnit, 1, RoundingMode.DOWN);
    }

    public static long dayToHour(long num) {
        return DateTimeConverterUtil.unitConversion(num, TimeUnit.DAYS, TimeUnit.HOURS);
    }

    public static long dayToMinute(long num) {
        return DateTimeConverterUtil.unitConversion(num, TimeUnit.DAYS, TimeUnit.MINUTES);
    }

    public static long dayToSecond(long num) {
        return DateTimeConverterUtil.unitConversion(num, TimeUnit.DAYS, TimeUnit.SECONDS);
    }

    public static long dayToMillisecond(long num) {
        return DateTimeConverterUtil.unitConversion(num, TimeUnit.DAYS, TimeUnit.MILLISECONDS);
    }

    public static long hourToMinute(long num) {
        return DateTimeConverterUtil.unitConversion(num, TimeUnit.HOURS, TimeUnit.MINUTES);
    }

    public static long hourToSecond(long num) {
        return DateTimeConverterUtil.unitConversion(num, TimeUnit.HOURS, TimeUnit.SECONDS);
    }

    public static long hourToMillisecond(long num) {
        return DateTimeConverterUtil.unitConversion(num, TimeUnit.HOURS, TimeUnit.MILLISECONDS);
    }

    public static long hourToDay(long num) {
        return DateTimeConverterUtil.unitConversion(num, TimeUnit.HOURS, TimeUnit.DAYS);
    }

    public static BigDecimal hourToDayPrecise(long num) {
        return DateTimeConverterUtil.unitConversionPrecise(num, TimeUnit.HOURS, TimeUnit.DAYS);
    }

    public static String hourToDayPreciseString(long num) {
        return DateTimeConverterUtil.hourToDayPrecise(num).stripTrailingZeros().toPlainString();
    }

    public static long minuteToSecond(long num) {
        return DateTimeConverterUtil.unitConversion(num, TimeUnit.MINUTES, TimeUnit.SECONDS);
    }

    public static long minuteToMillisecond(long num) {
        return DateTimeConverterUtil.unitConversion(num, TimeUnit.MINUTES, TimeUnit.MILLISECONDS);
    }

    public static long minuteToHour(long num) {
        return DateTimeConverterUtil.unitConversion(num, TimeUnit.MINUTES, TimeUnit.HOURS);
    }

    public static BigDecimal minuteToHourPrecise(long num) {
        return DateTimeConverterUtil.unitConversionPrecise(num, TimeUnit.MINUTES, TimeUnit.HOURS);
    }

    public static String minuteToHourPreciseString(long num) {
        return DateTimeConverterUtil.minuteToHourPrecise(num).stripTrailingZeros().toPlainString();
    }

    public static long minuteToDay(long num) {
        return DateTimeConverterUtil.unitConversion(num, TimeUnit.MINUTES, TimeUnit.DAYS);
    }

    public static BigDecimal minuteToDayPrecise(long num) {
        return DateTimeConverterUtil.unitConversionPrecise(num, TimeUnit.MINUTES, TimeUnit.DAYS);
    }

    public static String minuteToDayPreciseString(long num) {
        return DateTimeConverterUtil.minuteToDayPrecise(num).stripTrailingZeros().toPlainString();
    }

    public static long secondToMillisecond(long num) {
        return DateTimeConverterUtil.unitConversion(num, TimeUnit.SECONDS, TimeUnit.MILLISECONDS);
    }

    public static long secondToMinute(long num) {
        return DateTimeConverterUtil.unitConversion(num, TimeUnit.SECONDS, TimeUnit.MINUTES);
    }

    public static BigDecimal secondToMinutePrecise(long num) {
        return DateTimeConverterUtil.unitConversionPrecise(num, TimeUnit.SECONDS, TimeUnit.MINUTES);
    }

    public static String secondToMinutePreciseString(long num) {
        return DateTimeConverterUtil.secondToMinutePrecise(num).stripTrailingZeros().toPlainString();
    }

    public static long secondToHour(long num) {
        return DateTimeConverterUtil.unitConversion(num, TimeUnit.SECONDS, TimeUnit.HOURS);
    }

    public static BigDecimal secondToHourPrecise(long num) {
        return DateTimeConverterUtil.unitConversionPrecise(num, TimeUnit.SECONDS, TimeUnit.HOURS);
    }

    public static String secondToHourPreciseString(long num) {
        return DateTimeConverterUtil.secondToHourPrecise(num).stripTrailingZeros().toPlainString();
    }

    public static long secondToDay(long num) {
        return DateTimeConverterUtil.unitConversion(num, TimeUnit.SECONDS, TimeUnit.DAYS);
    }

    public static BigDecimal secondToDayPrecise(long num) {
        return DateTimeConverterUtil.unitConversionPrecise(num, TimeUnit.SECONDS, TimeUnit.DAYS);
    }

    public static String secondToDayPreciseString(long num) {
        return DateTimeConverterUtil.secondToDayPrecise(num).stripTrailingZeros().toPlainString();
    }

    public static long millisecondToSecond(long num) {
        return DateTimeConverterUtil.unitConversion(num, TimeUnit.MILLISECONDS, TimeUnit.SECONDS);
    }

    public static BigDecimal millisecondToSecondPrecise(long num) {
        return DateTimeConverterUtil.unitConversionPrecise(num, TimeUnit.MILLISECONDS, TimeUnit.SECONDS);
    }

    public static String millisecondToSecondPreciseString(long num) {
        return DateTimeConverterUtil.millisecondToSecondPrecise(num).stripTrailingZeros().toPlainString();
    }

    public static BigDecimal millisecondToSecondPreciseThree(long num) {
        return DateTimeConverterUtil.unitConversionPrecise(num, TimeUnit.MILLISECONDS, TimeUnit.SECONDS, 3, RoundingMode.DOWN);
    }

    public static String millisecondToSecondPreciseThreeString(long num) {
        return DateTimeConverterUtil.millisecondToSecondPreciseThree(num).stripTrailingZeros().toPlainString();
    }

    public static String millisecondToSecondPreciseThreePlainString(long num) {
        return DateTimeConverterUtil.millisecondToSecondPreciseThree(num).toPlainString();
    }

    public static long millisecondToMinute(long num) {
        return DateTimeConverterUtil.unitConversion(num, TimeUnit.MILLISECONDS, TimeUnit.MINUTES);
    }

    public static BigDecimal millisecondToMinutePrecise(long num) {
        return DateTimeConverterUtil.unitConversionPrecise(num, TimeUnit.MILLISECONDS, TimeUnit.MINUTES);
    }

    public static String millisecondToMinutePreciseString(long num) {
        return DateTimeConverterUtil.millisecondToMinutePrecise(num).stripTrailingZeros().toPlainString();
    }

    public static long millisecondToHour(long num) {
        return DateTimeConverterUtil.unitConversion(num, TimeUnit.MILLISECONDS, TimeUnit.HOURS);
    }

    public static BigDecimal millisecondToHourPrecise(long num) {
        return DateTimeConverterUtil.unitConversionPrecise(num, TimeUnit.MILLISECONDS, TimeUnit.HOURS);
    }

    public static String millisecondToHourPreciseString(long num) {
        return DateTimeConverterUtil.millisecondToHourPrecise(num).stripTrailingZeros().toPlainString();
    }

    public static long millisecondToDay(long num) {
        return DateTimeConverterUtil.unitConversion(num, TimeUnit.MILLISECONDS, TimeUnit.DAYS);
    }

    public static BigDecimal millisecondToDayPrecise(long num) {
        return DateTimeConverterUtil.unitConversionPrecise(num, TimeUnit.MILLISECONDS, TimeUnit.DAYS);
    }

    public static String millisecondToDayPreciseString(long num) {
        return DateTimeConverterUtil.millisecondToDayPrecise(num).stripTrailingZeros().toPlainString();
    }
}

