/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time.utils;

import java.io.Serializable;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

public class BaseCache<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<K, V> cache;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public BaseCache() {
        this(new WeakHashMap());
    }

    public BaseCache(Map<K, V> initMap) {
        this.cache = initMap;
    }

    public V get(K key) {
        this.lock.readLock().lock();
        try {
            V v = this.cache.get(key);
            return v;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key, Supplier<V> supplier) {
        V value;
        block6: {
            value = this.get(key);
            if (value == null && supplier != null) {
                this.lock.writeLock().lock();
                try {
                    value = this.cache.get(key);
                    if (null != value) break block6;
                    try {
                        value = supplier.get();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    this.cache.put(key, value);
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
        }
        return value;
    }

    public V put(K key, V value) {
        this.lock.writeLock().lock();
        try {
            this.cache.put(key, value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return value;
    }

    public V remove(K key) {
        this.lock.writeLock().lock();
        try {
            V v = this.cache.remove(key);
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.cache.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

