/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.database.datasource;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.extension.parsers.BlockAttackSqlParser;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.plugins.tenant.TenantHandler;
import com.baomidou.mybatisplus.extension.plugins.tenant.TenantSqlParser;
import com.github.zuihou.context.BaseContextHandler;
import com.github.zuihou.database.datasource.MyMetaObjectHandler;
import com.github.zuihou.database.injector.MySqlInjector;
import com.github.zuihou.database.mybatis.WriteInterceptor;
import com.github.zuihou.database.mybatis.typehandler.FullLikeTypeHandler;
import com.github.zuihou.database.mybatis.typehandler.LeftLikeTypeHandler;
import com.github.zuihou.database.mybatis.typehandler.RightLikeTypeHandler;
import com.github.zuihou.database.parsers.DynamicTableNameParser;
import com.github.zuihou.database.properties.DatabaseProperties;
import com.github.zuihou.database.properties.MultiTenantType;
import com.github.zuihou.database.servlet.TenantWebMvcConfigurer;
import java.util.ArrayList;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;

public class BaseMybatisConfiguration {
    private static final Logger log = LoggerFactory.getLogger(BaseMybatisConfiguration.class);
    protected final DatabaseProperties databaseProperties;

    public BaseMybatisConfiguration(DatabaseProperties databaseProperties) {
        this.databaseProperties = databaseProperties;
    }

    @Bean
    @Order(value=15)
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="zuihou.database", name={"isNotWrite"}, havingValue="true")
    public WriteInterceptor getWriteInterceptor() {
        return new WriteInterceptor();
    }

    @Order(value=5)
    @Bean
    @ConditionalOnMissingBean
    public PaginationInterceptor paginationInterceptor() {
        PaginationInterceptor paginationInterceptor = new PaginationInterceptor();
        paginationInterceptor.setLimit(this.databaseProperties.getLimit());
        ArrayList<Object> sqlParserList = new ArrayList<Object>();
        if (this.databaseProperties.getIsBlockAttack().booleanValue()) {
            sqlParserList.add(new BlockAttackSqlParser());
        }
        log.info("\u5df2\u4e3a\u60a8\u5f00\u542f{}\u79df\u6237\u6a21\u5f0f", (Object)this.databaseProperties.getMultiTenantType().getDescribe());
        if (MultiTenantType.SCHEMA.eq(this.databaseProperties.getMultiTenantType())) {
            DynamicTableNameParser dynamicTableNameParser = new DynamicTableNameParser(this.databaseProperties.getTenantDatabasePrefix());
            sqlParserList.add(dynamicTableNameParser);
        } else if (MultiTenantType.COLUMN.eq(this.databaseProperties.getMultiTenantType())) {
            TenantSqlParser tenantSqlParser = new TenantSqlParser();
            tenantSqlParser.setTenantHandler(new TenantHandler(){

                public Expression getTenantId(boolean where) {
                    return new StringValue(BaseContextHandler.getTenant());
                }

                public String getTenantIdColumn() {
                    return BaseMybatisConfiguration.this.databaseProperties.getTenantIdColumn();
                }

                public boolean doTableFilter(String tableName) {
                    return false;
                }
            });
            sqlParserList.add(tenantSqlParser);
        }
        paginationInterceptor.setSqlParserList(sqlParserList);
        return paginationInterceptor;
    }

    @Bean(value={"myMetaObjectHandler"})
    @ConditionalOnMissingBean
    public MetaObjectHandler getMyMetaObjectHandler() {
        DatabaseProperties.Id id = this.databaseProperties.getId();
        return new MyMetaObjectHandler(id.getWorkerId(), id.getDataCenterId());
    }

    @Bean
    public LeftLikeTypeHandler getLeftLikeTypeHandler() {
        return new LeftLikeTypeHandler();
    }

    @Bean
    public RightLikeTypeHandler getRightLikeTypeHandler() {
        return new RightLikeTypeHandler();
    }

    @Bean
    public FullLikeTypeHandler getFullLikeTypeHandler() {
        return new FullLikeTypeHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public MySqlInjector getMySqlInjector() {
        return new MySqlInjector();
    }

    @ConditionalOnProperty(prefix="zuihou.webmvc", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public static class WebMvcConfig {
        @Bean
        @ConditionalOnProperty(prefix="zuihou.webmvc", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public TenantWebMvcConfigurer getTenantWebMvcConfigurer() {
            return new TenantWebMvcConfigurer();
        }
    }
}

