/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.database.datasource.defaults;

import cn.hutool.core.util.ArrayUtil;
import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import com.baomidou.mybatisplus.autoconfigure.ConfigurationCustomizer;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusProperties;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusPropertiesCustomizer;
import com.github.zuihou.database.datasource.BaseDatabaseConfiguration;
import com.github.zuihou.database.properties.DatabaseProperties;
import com.p6spy.engine.spy.P6DataSource;
import java.util.List;
import javax.sql.DataSource;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.TypeHandler;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

public abstract class MasterDatabaseConfiguration
extends BaseDatabaseConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MasterDatabaseConfiguration.class);
    public static final String DATABASE_PREFIX = "master";

    public MasterDatabaseConfiguration(MybatisPlusProperties properties, DatabaseProperties databaseProperties, ObjectProvider<Interceptor[]> interceptorsProvider, ObjectProvider<TypeHandler[]> typeHandlersProvider, ObjectProvider<LanguageDriver[]> languageDriversProvider, ResourceLoader resourceLoader, ObjectProvider<DatabaseIdProvider> databaseIdProvider, ObjectProvider<List<ConfigurationCustomizer>> configurationCustomizersProvider, ObjectProvider<List<MybatisPlusPropertiesCustomizer>> mybatisPlusPropertiesCustomizerProvider, ApplicationContext applicationContext) {
        super(properties, databaseProperties, interceptorsProvider, typeHandlersProvider, languageDriversProvider, resourceLoader, databaseIdProvider, configurationCustomizersProvider, mybatisPlusPropertiesCustomizerProvider, applicationContext);
        log.debug("\u68c0\u6d4b\u5230 zuihou.database.multiTenantType!=DATASOURCE\uff0c\u52a0\u8f7d\u4e86 AuthorityDatabaseAutoConfiguration");
    }

    @Bean(value={"masterSqlSessionTemplate"})
    public SqlSessionTemplate getSqlSessionTemplate(@Qualifier(value="masterSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        ExecutorType executorType = this.properties.getExecutorType();
        if (executorType != null) {
            return new SqlSessionTemplate(sqlSessionFactory, executorType);
        }
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    @Primary
    @Bean(name={"masterDruidDataSource"})
    @ConfigurationProperties(prefix="spring.datasource.druid")
    public DataSource druidDataSource() {
        return DruidDataSourceBuilder.create().build();
    }

    @Bean(name={"masterDataSource"})
    public DataSource dataSource(@Qualifier(value="masterDruidDataSource") DataSource dataSource) {
        if (ArrayUtil.contains((Object[])DEV_PROFILES, (Object)this.profiles)) {
            return new P6DataSource(dataSource);
        }
        return dataSource;
    }

    @Bean(value={"masterSqlSessionFactory"})
    public SqlSessionFactory getSqlSessionFactory(@Qualifier(value="masterDataSource") DataSource dataSource) throws Exception {
        return super.sqlSessionFactory(dataSource);
    }

    @Bean(name={"masterTransactionManager"})
    public DataSourceTransactionManager dsTransactionManager(@Qualifier(value="masterDataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }
}

