/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.database.mybatis;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.handlers.AbstractSqlParserHandler;
import com.github.zuihou.context.BaseContextHandler;
import com.github.zuihou.exception.BizException;
import com.github.zuihou.utils.SpringUtils;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class WriteInterceptor
extends AbstractSqlParserHandler
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(WriteInterceptor.class);

    public Object intercept(Invocation invocation) {
        if (!((Boolean)SpringUtils.getApplicationContext().getEnvironment().getProperty("zuihou.database.isNotWrite", Boolean.class, (Object)false)).booleanValue()) {
            return invocation.proceed();
        }
        StatementHandler statementHandler = (StatementHandler)PluginUtils.realTarget((Object)invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        this.sqlParser(metaObject);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        if (SqlCommandType.SELECT.equals((Object)mappedStatement.getSqlCommandType())) {
            return invocation.proceed();
        }
        if (StrUtil.containsAnyIgnoreCase((CharSequence)mappedStatement.getId(), (CharSequence[])new CharSequence[]{"UserToken", "sms", "MsgsCenterInfo", "resetPassErrorNum", "updateLastLoginTime", "OptLog", "LoginLog", "File", "xxl"})) {
            return invocation.proceed();
        }
        Long userId = BaseContextHandler.getUserId();
        String tenant = BaseContextHandler.getTenant();
        log.info("mapperid={}, userId={}", (Object)mappedStatement.getId(), (Object)userId);
        if (userId == 2L && SqlCommandType.DELETE.equals((Object)mappedStatement.getSqlCommandType())) {
            throw new BizException(-1, "\u6f14\u793a\u73af\u5883\uff0c\u65e0\u5220\u9664\u6743\u9650\uff0c\u8bf7\u672c\u5730\u90e8\u7f72\u540e\u6d4b\u8bd5");
        }
        boolean isWrite = CollectionUtil.contains(Arrays.asList(SqlCommandType.DELETE, SqlCommandType.INSERT, SqlCommandType.UPDATE), (Object)mappedStatement.getSqlCommandType());
        if ("0000".equals(tenant) && isWrite) {
            throw new BizException(-1, "\u6f14\u793a\u73af\u5883\uff0c\u65e0\u6743\u9650, \u8bf7\u81ea\u884c\u521b\u5efa\u79df\u6237\u540e\u6d4b\u8bd5\u5199\u5165");
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

