/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.database.parsers;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.parser.ISqlParser;
import com.baomidou.mybatisplus.core.parser.SqlInfo;
import com.github.zuihou.context.BaseContextHandler;
import com.github.zuihou.database.parsers.ReplaceSql;
import org.apache.ibatis.reflection.MetaObject;

public class DynamicTableNameParser
implements ISqlParser {
    private String tenantDatabasePrefix;

    public DynamicTableNameParser(String tenantDatabasePrefix) {
        this.tenantDatabasePrefix = tenantDatabasePrefix;
    }

    public SqlInfo parser(MetaObject metaObject, String sql) {
        if (this.allowProcess(metaObject)) {
            String tenantCode = BaseContextHandler.getTenant();
            if (StrUtil.isEmpty((CharSequence)tenantCode)) {
                return null;
            }
            String schemaName = StrUtil.format((CharSequence)"{}_{}", (Object[])new Object[]{this.tenantDatabasePrefix, tenantCode});
            String parsedSql = ReplaceSql.replaceSql(schemaName, sql);
            return SqlInfo.newInstance().setSql(parsedSql);
        }
        return null;
    }

    private boolean allowProcess(MetaObject metaObject) {
        return true;
    }

    public String getTenantDatabasePrefix() {
        return this.tenantDatabasePrefix;
    }

    public DynamicTableNameParser setTenantDatabasePrefix(String tenantDatabasePrefix) {
        this.tenantDatabasePrefix = tenantDatabasePrefix;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicTableNameParser)) {
            return false;
        }
        DynamicTableNameParser other = (DynamicTableNameParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tenantDatabasePrefix = this.getTenantDatabasePrefix();
        String other$tenantDatabasePrefix = other.getTenantDatabasePrefix();
        return !(this$tenantDatabasePrefix == null ? other$tenantDatabasePrefix != null : !this$tenantDatabasePrefix.equals(other$tenantDatabasePrefix));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamicTableNameParser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tenantDatabasePrefix = this.getTenantDatabasePrefix();
        result = result * 59 + ($tenantDatabasePrefix == null ? 43 : $tenantDatabasePrefix.hashCode());
        return result;
    }

    public String toString() {
        return "DynamicTableNameParser(tenantDatabasePrefix=" + this.getTenantDatabasePrefix() + ")";
    }

    public DynamicTableNameParser() {
    }
}

