/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.service;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.handler.XmlResponsesSaxParser;
import com.obs.services.internal.io.HttpMethodReleaseInputStream;
import com.obs.services.internal.service.AbstractRequestConvertor;
import com.obs.services.internal.service.ObsObjectService;
import com.obs.services.internal.trans.NewTransResult;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.SpecialParamEnum;
import com.obs.services.model.StorageClassEnum;
import com.obs.services.model.fs.ContentSummaryFsRequest;
import com.obs.services.model.fs.ContentSummaryFsResult;
import com.obs.services.model.fs.ListContentSummaryFsRequest;
import com.obs.services.model.fs.ListContentSummaryFsResult;
import com.obs.services.model.fs.ListContentSummaryRequest;
import com.obs.services.model.fs.ListContentSummaryResult;
import com.obs.services.model.fs.ObsFSFile;
import com.obs.services.model.fs.RenameRequest;
import com.obs.services.model.fs.RenameResult;
import com.obs.services.model.fs.TruncateFileRequest;
import com.obs.services.model.fs.TruncateFileResult;
import com.obs.services.model.fs.WriteFileRequest;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import shade.okhttp3.Response;

public abstract class ObsFileService
extends ObsObjectService {
    private static final ILogger log = LoggerBuilder.getLogger(ObsFileService.class);

    protected TruncateFileResult truncateFileImpl(TruncateFileRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.TRUNCATE.getOriginalStringCode(), "");
        requestParams.put("length", String.valueOf(request.getNewLength()));
        Map<String, String> headers = this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName()));
        NewTransResult transResult = this.transObjectRequest(request);
        transResult.setParams(requestParams);
        transResult.setHeaders(headers);
        Response response = this.performRequest(transResult);
        TruncateFileResult result = new TruncateFileResult();
        this.setHeadersAndStatus(result, response);
        return result;
    }

    protected RenameResult renameFileImpl(RenameRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.RENAME.getOriginalStringCode(), "");
        requestParams.put("name", request.getNewObjectKey());
        Map<String, String> headers = this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName()));
        NewTransResult transResult = this.transObjectRequest(request);
        transResult.setParams(requestParams);
        transResult.setHeaders(headers);
        Response response = this.performRequest(transResult);
        RenameResult result = new RenameResult();
        this.setHeadersAndStatus(result, response);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObsFSFile writeFileImpl(WriteFileRequest request) throws ServiceException {
        ObsFSFile ret;
        block8: {
            Response response;
            boolean isExtraAclPutRequired;
            AbstractRequestConvertor.TransResult result = null;
            AccessControlList acl = request.getAcl();
            try {
                result = this.transWriteFileRequest(request);
                isExtraAclPutRequired = !this.prepareRESTHeaderAcl(request.getBucketName(), result.getHeaders(), acl);
                NewTransResult newTransResult = this.transObjectRequestWithResult(result, request);
                response = this.performRequest(newTransResult);
            }
            finally {
                if (result != null && result.getBody() != null && request.isAutoClose() && result.getBody() instanceof Closeable) {
                    ServiceUtils.closeStream((Closeable)((Object)result.getBody()));
                }
            }
            ret = new ObsFSFile(request.getBucketName(), request.getObjectKey(), response.header("ETag"), response.header(this.getIHeaders(request.getBucketName()).versionIdHeader()), StorageClassEnum.getValueFromCode(response.header(this.getIHeaders(request.getBucketName()).storageClassHeader())), this.getObjectUrl(request.getBucketName(), request.getObjectKey(), request.getIsIgnorePort()));
            this.setHeadersAndStatus(ret, response);
            if (isExtraAclPutRequired && acl != null) {
                try {
                    this.putAclImpl(request.getBucketName(), request.getObjectKey(), acl, null, request.isRequesterPays());
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block8;
                    log.warn("Try to set object acl error", e);
                }
            }
        }
        return ret;
    }

    protected ListContentSummaryResult listContentSummaryImpl(ListContentSummaryRequest listContentSummaryRequest) throws ServiceException {
        AbstractRequestConvertor.TransResult result = this.transListContentSummaryRequest(listContentSummaryRequest);
        Response httpResponse = this.performRestGet(listContentSummaryRequest.getBucketName(), null, result.getParams(), null, listContentSummaryRequest.getUserHeaders());
        this.verifyResponseContentType(httpResponse);
        XmlResponsesSaxParser.ListContentSummaryHandler listContentSummaryHandler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.ListContentSummaryHandler.class, true);
        ListContentSummaryResult contentSummaryResult = new ListContentSummaryResult.Builder().folderContentSummaries(listContentSummaryHandler.getFolderContentSummaries()).bucketName(listContentSummaryHandler.getBucketName() == null ? listContentSummaryRequest.getBucketName() : listContentSummaryHandler.getBucketName()).truncated(listContentSummaryHandler.isListingTruncated()).prefix(listContentSummaryHandler.getRequestPrefix() == null ? listContentSummaryRequest.getPrefix() : listContentSummaryHandler.getRequestPrefix()).marker(listContentSummaryHandler.getRequestMarker() == null ? listContentSummaryRequest.getMarker() : listContentSummaryHandler.getRequestMarker()).maxKeys(listContentSummaryHandler.getRequestMaxKeys()).delimiter(listContentSummaryHandler.getRequestDelimiter() == null ? listContentSummaryRequest.getDelimiter() : listContentSummaryHandler.getRequestDelimiter()).nextMarker(listContentSummaryHandler.getMarkerForNextListing()).location(httpResponse.header(this.getIHeaders(listContentSummaryRequest.getBucketName()).bucketRegionHeader())).builder();
        this.setHeadersAndStatus(contentSummaryResult, httpResponse);
        return contentSummaryResult;
    }

    protected ListContentSummaryFsResult listContentSummaryFsImpl(ListContentSummaryFsRequest listContentSummaryFsRequest) throws ServiceException {
        AbstractRequestConvertor.TransResult result = this.transListContentSummaryFsRequest(listContentSummaryFsRequest);
        Response httpResponse = this.performRestGet(listContentSummaryFsRequest.getBucketName(), null, result.getParams(), result.getHeaders(), listContentSummaryFsRequest.getUserHeaders());
        this.verifyResponseContentType(httpResponse);
        XmlResponsesSaxParser.ListContentSummaryFsHandler listContentSummaryFsHandler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.ListContentSummaryFsHandler.class, true);
        ListContentSummaryFsResult listContentSummaryFsResult = new ListContentSummaryFsResult();
        listContentSummaryFsResult.setDirContentSummaries(listContentSummaryFsHandler.getDirContentSummaries());
        listContentSummaryFsResult.setErrorResults(listContentSummaryFsHandler.getErrorResults());
        this.setHeadersAndStatus(listContentSummaryFsResult, httpResponse);
        return listContentSummaryFsResult;
    }

    protected ContentSummaryFsResult getContentSummaryFsImpl(ContentSummaryFsRequest contentSummaryFsRequest) throws ServiceException {
        AbstractRequestConvertor.TransResult result = this.transGetContentSummaryFs(contentSummaryFsRequest);
        Response httpResponse = this.performRestGet(contentSummaryFsRequest.getBucketName(), contentSummaryFsRequest.getDirName().equals("/") ? null : contentSummaryFsRequest.getDirName(), result.getParams(), null, contentSummaryFsRequest.getUserHeaders());
        this.verifyResponseContentType(httpResponse);
        XmlResponsesSaxParser.ContentSummaryFsHandler contentSummaryFsHandler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.ContentSummaryFsHandler.class, true);
        ContentSummaryFsResult contentSummaryFsResult = new ContentSummaryFsResult();
        contentSummaryFsResult.setContentSummary(contentSummaryFsHandler.getContentSummary());
        this.setHeadersAndStatus(contentSummaryFsResult, httpResponse);
        return contentSummaryFsResult;
    }
}

